package com.blt.other.module.auth.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.sys.dto.request.CompanyReviewerListReq;
import com.blt.other.module.auth.model.OaCompany;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface IOaCompanyService extends IService<OaCompany> {

    /**
     * <p>
     * 获取百伦公司主体
     * </p>
     *
     * @return 百伦公司主体
     */
    List<OaCompany> oaCompanyList();

    /**
     * <p>
     * 查询财务审核人和最终审核人配置
     * </p>
     *
     * @param req req
     * @return 财务审核人和最终审核人配置
     */
    IPage<OaCompany> reviewerList(CompanyReviewerListReq req);


    /**
     * oa公司字典 缓存
     *
     * @return oa公司字典
     */
    Map<String, OaCompany> companyDict();
}
