package com.blt.other.module.cost.dao;

import com.bailuntec.cost.api.request.ManageCostListReq;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.AppCheckCostListReq;
import com.blt.other.module.cost.dto.request.AppCostListReq;
import com.blt.other.module.cost.dto.request.CheckCostListReq;
import com.blt.other.module.cost.dto.request.CostQueryPageReq;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.CostExportVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface CostDao extends BaseMapper<CostDomain> {

    //获取费用单列表
    List<CostDomain> selectAll(@Param("userId") Integer userId,
                               @Param("projectTypeList") List<String> projectTypeList);

    //根据 costNo 获取费用单详情
    CostDomain selectByCostNo(String costNo);

    List<CostDomain> selectByKeys(CostDomain costDomain);

    //根据 费用计划获取费用单详情
    List<CostDomain> selectByCostPlanNo(String costPlanNo);

    //查询最近一次费用单
    CostDomain selectLastCost();

    List<CostDomain> selectLinkLendCost(@Param("createuserid") Integer createuserid);

    //
    List<String> listCostNoAll(CostExportVo costExportVo);


    //管理后台 需要财务审核或者需要我最终审核费用列表查询
    IPage<CostDomain> financialOrFinalCheckCostList(@Param("page") IPage<CostDomain> page,
                                                    @Param("req") CheckCostListReq req);

    //管理后台 需要我部门审核费用列表查询
    IPage<CostDomain> departmentCheckCostList(@Param("page") IPage<CostDomain> page,
                                              @Param("req") CheckCostListReq req);

    //管理后台 所有需要部门审核 + 部门审核通过 费用列表查询
    IPage<CostDomain> departmentCheckAllCostList(@Param("page") IPage<CostDomain> page,
                                                 @Param("req") CheckCostListReq req);

    //管理后台 已经部门手动审核费用列表查询
    IPage<CostDomain> departmentManualCheckLllCostList(@Param("page") IPage<CostDomain> page,
                                                       @Param("req") CheckCostListReq req);

    //管理后台 已经部门自动核费用列表查询
    IPage<CostDomain> departmentAutoCheckLllCostList(@Param("page") IPage<CostDomain> page,
                                                     @Param("req") CheckCostListReq req);

    //管理后台 需要我人事审核费用列表查询
    IPage<CostDomain> hrCheckCostList(@Param("page") IPage<CostDomain> page,
                                      @Param("req") CheckCostListReq req);

    //管理后台 需要我总经办审核费用列表查询
    IPage<CostDomain> generalManagerCheckCostList(@Param("page") IPage<CostDomain> page,
                                      @Param("req") CheckCostListReq req);

    //小程序审核列表查询
    Page<CostDomain> appCheckCostList(@Param("page") IPage<CostDomain> page,
                                      @Param("req") AppCheckCostListReq req);

    //小程序列表查询
    Page<CostDomain> appCostList(@Param("page") IPage<CostDomain> costDomainIPage,
                                 @Param("req") AppCostListReq req);

    //根据费用单状态获取费用单
    List<CostDomain> selectByStatus(Integer costStatus);

    /**
     * 分页查询费用单
     *
     * @param page
     * @param req
     * @return
     */
    Page<CostDomain> queryPage(@Param("page") Page<Object> page,
                               @Param("req") CostQueryPageReq req);

    List<CostDomain> manageCostList(ManageCostListReq req);

    List<CostDomain> getCostList(@Param("page") IPage<CostDomain> page,
                                 @Param("startDate") String startDate,
                                 @Param("endDate") String endDate);
}
