package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.database.model.UserCostFinansysDomain;
import com.blt.other.module.cost.service.UserCostFinansysService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/2/25 1:58 下午
 */
@Transactional
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("prod")
@Slf4j
public class UserCostFinansysServiceImplTest {

    @Resource
    UserCostFinansysService userCostFinansysService;

    @Test
    public void getAllFinancesRecord() {
        List<UserCostFinansysDomain> userCostFinansysDomainList = userCostFinansysService.getAllFinancesRecord("test");
        log.info("res:{}", JsonUtilByFsJson.beanToJson(userCostFinansysDomainList));

        List<UserCostFinansysDomain> userCostFinansysDomainListNull = userCostFinansysService.getAllFinancesRecord(null);
        log.info("res:{}", JsonUtilByFsJson.beanToJson(userCostFinansysDomainListNull));
    }
}
