package com.blt.other.module.sku.dao;

import com.blt.other.database.model.SkuTypeDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface SkuTypeDao {

    /**
     * 添加 sku 大类
     * @param skuTypeDomain
     * @return
     */
    Integer insert(SkuTypeDomain skuTypeDomain);

    /**
     * 根据编号获取 sku 大类
     * @param skuTypeNo
     * @return
     */
    SkuTypeDomain selectBySkuTypeNo(String skuTypeNo);

    /**
     *
     * 根据 skuTypeName 获取 sku 大类
     * @param skuTypeName
     * @return
     */
    List<SkuTypeDomain> selectBySkuTypeName(String skuTypeName);

    /**
     * 获取所有 sku 大类
     * @return
     */
    List<SkuTypeDomain> selectAll();
}
