package com.blt.other.common.job;

import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @Author: li.yanlin
 * @Description： 同步OA用户，免得每次有新同事使用OA都要同步一次
 * @Date: Created in 17:12 2021-04-24
 * @Modified by:
 */
@Configuration
public class OaUserSyncJobConfiguration {
    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 60 * 60 * 2;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail oaUserSyncJobDetail() {
        return JobBuilder.newJob(OaUserSyncJob.class)
                .withIdentity("oaUserSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger oaUserSyncJobTrigger() {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(oaUserSyncJobDetail())
                .withIdentity("oaUserSyncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
