package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.AllCheckCostListReq;
import com.blt.other.module.cost.dto.request.CheckCostListReq;
import com.blt.other.module.cost.dto.request.CostQueryPageReq;
import com.blt.other.module.cost.dto.response.CostPageResult;
import com.blt.other.module.cost.dto.response.UpdateCostResp;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.ApplyCallbackUrlVo;
import com.blt.other.module.cost.vo.CashierCallbackUrlVo;

import java.util.List;

public interface CostService {


    void setPrimaryDepartment(List<CostDomain> costDomains);

    /**
     * 根据 costNo 获取 cost
     *
     * @param costNo costNo
     * @return cost
     */
    CostDomain getCostByCostNo(String costNo);

    /**
     * 修改费用单信息
     *
     * @param costDomain costDomain
     * @return res
     */
    UpdateCostResp updateCost(CostDomain costDomain);


    /**
     * 根据费计划查询费用单
     *
     * @param costPlanNo 计划单号
     * @return 费用单
     */
    List<CostDto> getByCostPlanNo(String costPlanNo);

    /**
     * 刷新费用单
     *
     * @param costNo 费用单号
     */
    void resetCost(String costNo);

    /**
     * 更新费用单状态
     *
     * @param costNo 费用单号
     * @param i      status
     * @return res
     */
    Integer setStatus(String costNo, int i);

    /**
     * 更新费用单
     *
     * @param costDomain entity
     * @return res
     */
    Integer updateById(CostDomain costDomain);


    /**
     * 更新附件
     *
     * @param costNo      费用单编号
     * @param filePath    文件
     * @param downloadUrl 附件
     */
    void updateCashierAnnex(String costNo, String filePath, String downloadUrl);

    /**
     * <p>
     * 获取费用单号对应的前端需要的打印参数
     * </p>
     *
     * @param printNos 费用单号列表
     * @return res
     */
    List<CostListPrintDto> printList(List<String> printNos);


    /**
     * 审核费用单列表
     *
     * @param req req
     * @return 费用单列表
     */
    IPage<CostDto> checkCostList(CheckCostListReq req);

    IPage<CostDto> checkCostAllList(AllCheckCostListReq req);

    /**
     * <p>
     * 审核成功通知财务系统付款
     * </p>
     *
     * @param costDomain cost
     */
    void toFinancial(CostDomain costDomain);

    /**
     * <p>
     * 财务审核回调
     * </p>
     *
     * @param applyCallbackUrlVo req
     */
    void applyCallback(ApplyCallbackUrlVo applyCallbackUrlVo);

    /**
     * 出纳付款回调
     *
     * @param cashierCallbackUrlVo req
     */
    void cashierCallback(CashierCallbackUrlVo cashierCallbackUrlVo);

    /**
     * 审批拒绝handle
     *
     * @param costNo costNo
     */
    void reject(String costNo);

    /**
     * 分页查询费用单
     *
     * @param req req
     * @return res
     */
    Page<CostDomain> queryPage(CostQueryPageReq req);

    Page<CostDomain> queryPageFor4k(Page page,String sourceFrom);
}
