package com.bailuntec.cost.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CostListPrintDto {
    private Integer id;
    private String costFormStr; // 打印单头部费用单类型水印
    private String companyName; // 主体名称
    private String department; // 部门名称
    private String createUsername; // 申请人
    private String costNo; // 费用单号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime; // 创建时间
    private String bankCompanyStr; // “收款单位”/“付款单位”  （付款、借支：收款单位   收款、借还：付款单位）
    private String bankCompany; // 收款/付款单位
    private String bankCardUserStr; // “收款户名”/“付款户名”  （付款、借支：收款户名   收款、借还：付款户名）
    private String bankCardUser; // “收款户名”/“付款户名”
    private String feeTypeStr; // “收款方式”/“付款方式”  （付款、借支：付款方式   收款、借还：收款方式）
    private String bankCardStr; // “收款账户”/“付款账户”  （付款、借支：收款账户   收款、借还：付款账户）
    private String bankCard; // “收款账户”/“付款账户”
    private String costReasonStr; // “收款理由”/“付款理由”  （付款、借支：付款理由   收款、借还：收款理由）
    private String costReason; // “收款理由”/“付款理由”
    private String costAmountStr; // “收款金额”/“付款金额”  （付款、借支：付款金额   收款、借还：收款金额）
    private String dic; // 币种
    private String amount; // 金额
    private String txtAmount; // 金额（大写）
    private String supCostNo; // 关联借支单
    private BigDecimal payCounteract; // 冲销金额
    private BigDecimal payLendBalance; // 借还余额

}
