package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.dto.CostPlanTempDto;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.CostPlanTempService;
import com.blt.other.other_cost.service.CostTypeKindService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_cost.vo.CurVo;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_database.model.CostPlanTempDomain;
import com.blt.other.other_database.model.CostTypeKindDomain;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/cost/plan/temp")
public class CostPlanTempController {

    @Autowired
    private CostPlanTempService costPlanTempService;

    @Autowired
    private CostTypeKindService costTypeKindService;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private CostPlanService costPlanService;

    @PostMapping("/addItem/noFile")
    public Map<String,Object> noFile(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        CostPlanTempDomain domain = createDomain(request);
        Map<String, Object> result = doSave(domain);
        String planAmountStr = request.getParameter("planAmount");
        if (null != planAmountStr && !planAmountStr.isEmpty()){
            BigDecimal planAmount = null;
            try {
                planAmount = new BigDecimal(planAmountStr);
            }catch (NumberFormatException e){
                planAmount = new BigDecimal(0);
            }
            BigDecimal cur = CurUtils.getCur(domain.getDic(), "CNY",getExchangeRateApi);
            result.put("planAmount",planAmount.add(domain.getAmount().multiply(cur)));
        }
        return result;
    }

    @PostMapping("/addItem/file")
    public Map<String,Object> file(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect") MultipartFile file){
        AxiosUtil.setCors(response,request);
        CostPlanTempDomain domain = createDomain(request);

        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+domain.getTempNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        domain.setFilePath(path);

        Map<String, Object> result = doSave(domain);
        String planAmountStr = request.getParameter("planAmount");
        if (null != planAmountStr && !planAmountStr.isEmpty()){
            BigDecimal planAmount ;
            try {
                planAmount = new BigDecimal(planAmountStr);
            }catch (NumberFormatException e){
                planAmount = new BigDecimal(0);
            }
            BigDecimal cur = CurUtils.getCur(domain.getDic(), "CNY",getExchangeRateApi);
            result.put("planAmount",planAmount.add(domain.getAmount().multiply(cur)));
        }
        return result;
    }

    @GetMapping("/getCostTempByPlanNo")
    public Map<String,Object> getCostTempByPlanNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");

        List<CostPlanTempDto> temps = costPlanTempService.getTempListByPlanNo(costPlanNo);
        // TODO 遍历获取 planAmount
        if (null != temps && temps.size() >= 1){
            BigDecimal planAmount = new BigDecimal(0);
            BigDecimal cur;
            for (CostPlanTempDto tempDto: temps){
                cur = CurUtils.getCur(tempDto.getDic(), "CNY",getExchangeRateApi);
                planAmount = planAmount.add(tempDto.getAmount().multiply(cur));
            }
            result.put("planAmount",planAmount);
        }

        result.put("success",true);
        result.put("temps",temps);
        return result;
    }

    @PostMapping("/deleteItem")
    public Map<String,Object> deleteItem(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String costPlanNo = request.getParameter("costPlanNo");
        String planAmountStr = request.getParameter("planAmount");
        BigDecimal planAmount = null;
        if (null == planAmountStr || planAmountStr.isEmpty()){
            planAmount = new BigDecimal(0);
        }else {
            planAmount = new BigDecimal(planAmountStr);
        }
        String tempNo = request.getParameter("tempNo");
        CostPlanTempDomain planTemp = costPlanTempService.getByPlanNoAndTempNo(costPlanNo, tempNo);
        Integer deleted = costPlanTempService.deleteItemByPlanNoAndTempNo(costPlanNo,tempNo);
        if (null != deleted && deleted >= 0) {
            result.put("success", true);
            result.put("msg", "已删除");
            result.put("deleted",deleted);
            if (null != planTemp && null != planTemp.getAmount()){
                planAmount = planAmount.subtract(planTemp.getAmount());
            }
            result.put("planAmount", planAmount);
        }
        return result;
    }

    private CostPlanTempDomain createDomain(HttpServletRequest request){
        CostPlanTempDomain costPlanTempDomain = new CostPlanTempDomain();

        String costPlanNo = request.getParameter("costPlanNo");
        String costReason = request.getParameter("costReason");
        String amount = request.getParameter("amount");
        String kindNo = request.getParameter("kindNo");
        String dic = request.getParameter("dic");

        costPlanTempDomain.setCostPlanNo(costPlanNo);
        costPlanTempDomain.setTempNo(costPlanTempService.createNo());
        costPlanTempDomain.setCostReason(costReason);
        costPlanTempDomain.setAmount(new BigDecimal(amount));
        costPlanTempDomain.setKindNo(kindNo);
        costPlanTempDomain.setDic(dic);

        CostTypeKindDomain kindByKindNo = costTypeKindService.getKindByKindNo(kindNo);
        costPlanTempDomain.setTypeNo(kindByKindNo.getTypeNo());
        return costPlanTempDomain;
    }

    private Map<String,Object> doSave(CostPlanTempDomain costPlanTempDomain){
        Map<String,Object> result = new HashMap<>();
        // 判断是否已经存在
//        CostPlanTempDomain isEx = costPlanTempService.getByPlanNoAndKindNo(costPlanTempDomain.getCostPlanNo(),costPlanTempDomain.getKindNo());
//        if (null != isEx){
//            result.put("tmp",costPlanTempDomain);
//            result.put("success",false);
//            result.put("msg","付款项目已存在，请勿重复添加");
//            return result;
//        }
        // 判断是否已经存在相同的大类，而所选的币种不一样
        if (chackDic(costPlanTempDomain)){
            result.put("tmp",costPlanTempDomain);
            result.put("success",false);
            result.put("msg","已存在相同大类，请保持币种一致！");
            return result;
        }

        Integer save = costPlanTempService.save(costPlanTempDomain);
        if (save >= 1){
            result.put("tmp",costPlanTempDomain);
            result.put("success",true);
        }

        return result;
    }

    /**
     * 检查同一个付款计划中是否存在大类相同、币种不同的情况
     * @param costPlanTempDomain
     * @return
     */
    private boolean chackDic(CostPlanTempDomain costPlanTempDomain){
        List<CostPlanTempDomain> chackDic = costPlanTempService.getListByPlanNoAndTypeNo(costPlanTempDomain.getCostPlanNo(),costPlanTempDomain.getTypeNo());
        if (null != chackDic && chackDic.size() >= 1){
            CostPlanTempDomain costPlanTempDomain0 = chackDic.get(0);
            if (!costPlanTempDomain.getDic().equals(costPlanTempDomain0.getDic())){
                return true;
            }
        }
        return false;
    }

    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String tempNo = request.getParameter("tempNo");

        CostPlanTempDomain temp = costPlanTempService.getByTempNo(tempNo);
        String filePath = null;
        String fileName = null;
        if (null != temp) {
            filePath = temp.getFilePath();
            if (null != filePath){
                String[] split = filePath.split("&");
                if (null != split && split.length>=1){
                    fileName = split[split.length-1];
                }
            }
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"),"iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("/getByTempNo")
    public Map<String,Object> getByTempNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String tempNo = request.getParameter("tempNo");
        CostPlanTempDomain byTempNo = costPlanTempService.getByTempNo(tempNo);
        Map<String,Object> result = new HashMap<>();

        CostPlanTempDto dto = new CostPlanTempDto();

        BeanUtils.copyProperties(byTempNo,dto);

        dto.setFileName(PathUtil.getFileName(dto.getFilePath()));

        CostTypeKindDomain kindByKindNo = costTypeKindService.getKindByKindNo(dto.getKindNo());
        if (null != kindByKindNo) {
            dto.setTypeNameDto(kindByKindNo.getTypeName());
            dto.setKindNameDto(kindByKindNo.getKindName());
        }
        result.put("tmp",dto);
        return result;
    }

    @PostMapping("/resetItem/noFile")
    public Map<String,Object> resetNoFile(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        CostPlanTempDomain domain = createDomain(request);
        CostTypeKindDomain kindByKindNo = costTypeKindService.getKindByKindNo(domain.getKindNo());
        domain.setTypeNo(kindByKindNo.getTypeNo());
        String delecteFile = request.getParameter("delecteFile");
        String tempNo = request.getParameter("tempNo");
        domain.setTempNo(tempNo);
        boolean b = Boolean.parseBoolean(delecteFile);
        if (b){
            costPlanTempService.deleteFilePath(domain.getTempNo());
        }
        Map<String,Object> result = new HashMap<>();
        result.put("success",true);

//        result = checkResetKind(result, domain);
        result = chackResetDic(result, domain);
        if (!(boolean)result.get("success")){
            return result;
        }
        // 同步更新费用计划金额
        CostPlanTempDomain byTempNo = costPlanTempService.getByTempNo(tempNo);
        Integer update = costPlanTempService.update(domain);
        result.put("tmp",domain);
        if (null != update && update >= 1) {
            List<CostPlanTempDto> tempListByPlanNo = costPlanTempService.getTempListByPlanNo(byTempNo.getCostPlanNo());
            if (null != tempListByPlanNo && tempListByPlanNo.size() >= 1){
                CostPlanDomain plan = costPlanService.getByPlanNo(byTempNo.getCostPlanNo());
                if (null != plan) {
                    BigDecimal newAmount = new BigDecimal(0);
                    for (CostPlanTempDto tmp : tempListByPlanNo) {
                        newAmount = newAmount.add(tmp.getAmount());
                    }
                    plan.setPlanAmount(newAmount);
                    if (1 == plan.getCostForm() && (null != plan.getIsLend() && 2 == plan.getIsLend())) {
                        plan.setPayPlanAmount(newAmount.divide(plan.getPayCur(), 4));
                    }
                    costPlanService.update(plan);
                }
            }
            result.put("tmp", domain);
        }
        return result;
    }

    /**
     * 修改时判断是否存在相同的付款小类
     * @param result
     * @param domain
     * @return
     */
//    private Map<String,Object> checkResetKind(Map<String,Object> result,CostPlanTempDomain domain){
//        CostPlanTempDomain byPlanNoAndKindNo = costPlanTempService.getByPlanNoAndKindNo(domain.getCostPlanNo(), domain.getKindNo());
//        if (null != byPlanNoAndKindNo && null != byPlanNoAndKindNo.getTempNo()){
//            // 1 domain.tempNo == byPlanAndKindNo.tempNo
//            if (byPlanNoAndKindNo.getTempNo().equals(domain.getTempNo())){
//                return result;
//            }else {
//                result.put("success",false);
//                result.put("msg","已存在该小类子项目");
//            }
//            // 2 domain.tempNo != byPlanAndKindNo.tempNo
//        }
//        return result;
//    }

    private Map<String,Object> chackResetDic(Map<String,Object> result,CostPlanTempDomain domain){
        // 改变币种，判断是否存在大类相同，币种不同的情况
        CostPlanTempDomain byTempNo = costPlanTempService.getByTempNo(domain.getTempNo());
        if (null != byTempNo && null != byTempNo.getTypeNo()){
            if (byTempNo.getTypeNo().equals(domain.getTypeNo())){
                // 大类无变化，改币种
                List<CostPlanTempDomain> listByPlanNoAndTypeNo = costPlanTempService.getListByPlanNoAndTypeNo(domain.getCostPlanNo(), domain.getTypeNo());
                if (null != listByPlanNoAndTypeNo && listByPlanNoAndTypeNo.size() > 1){
                    // 该大类有多条记录，不允许改币种
                    if (!listByPlanNoAndTypeNo.get(0).getDic().equals(domain.getDic())){
                        result.put("success",false);
                        result.put("msg","该大类有多条记录，请保持币种一致");
                        return result;
                    }
                }
            }else {
                // 修改大类，改币种 / 修改大类，未改币种
                List<CostPlanTempDomain> listByPlanNoAndTypeNo = costPlanTempService.getListByPlanNoAndTypeNo(domain.getCostPlanNo(), domain.getTypeNo());
                if (null != listByPlanNoAndTypeNo && listByPlanNoAndTypeNo.size() >= 1){
                    if (!listByPlanNoAndTypeNo.get(0).getDic().equals(domain.getDic())){
                        result.put("success",false);
                        result.put("msg","该大类有多条记录，请保持币种一致");
                        return result;
                    }
                }
            }
        }
        return result;
    }
    @PostMapping("/resetItem/file")
    public Map<String,Object> resetFile(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect2") MultipartFile file){
        AxiosUtil.setCors(response,request);
        CostPlanTempDomain domain = createDomain(request);

        String tempNo = request.getParameter("tempNo");
        domain.setTempNo(tempNo);
        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+domain.getTempNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        domain.setFilePath(path);

        Map<String,Object> result = new HashMap<>();
        result.put("success",true);
        result = chackResetDic(result, domain);
        if (!(boolean)result.get("success")){
            return result;
        }
        Integer update = costPlanTempService.update(domain);
        if (null != update && update >= 1) {
            result.put("tmp", domain);
        }
        return result;
    }

    /**
     * 获取汇率
     * @param fromCur
     * @param toCur
     * @return
     */
//    private BigDecimal getCur(String fromCur,String toCur){
//        String url = getExchangeRateApi+"?"+"fromCUr="+fromCur+"&toCur="+toCur;
//        ResponseEntity<String> forEntity = restTemplate.getForEntity(url, String.class);
//        if (200 == forEntity.getStatusCodeValue()){
//            String body = forEntity.getBody();
//            body = body.toLowerCase();
//            body = body.replace("\\","");
//            body = body.substring(1,body.length()-1);
//            CurVo curVo = (CurVo)MyMapperUtil.getObject(body, CurVo.class);
//            return curVo.getRate();
//        }
//        return new BigDecimal(1);
//    }
}
