package com.blt.other.other_cost.controller;

import com.alibaba.fastjson.JSON;
import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_commons.utils.IpUtil;
import com.blt.other.other_cost.dto.CostDto;
import com.blt.other.other_cost.service.*;
import com.blt.other.other_cost.vo.ApplyCallbackUrlVo;
import com.blt.other.other_cost.vo.ApplyCallbackVo;
import com.blt.other.other_cost.vo.ApplyMoneyDetail;
import com.blt.other.other_cost.vo.CashierCallbackUrlVo;
import com.blt.other.other_database.model.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("cost/check")
public class CostCheckController {

    private static Logger logger = LoggerFactory.getLogger(CostCheckController.class);

    @Autowired
    private CostService costService;

    @Autowired
    private CostTypeKindService costTypeKindService;

    @Autowired
    private CostCompanyService costCompanyService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private CostTofinanceService costTofinanceService;

    @Autowired
    private CostApplycallbackService costApplycallbackService;

    @Autowired
    private CostCashiercallbackService costCashiercallbackService;

    @Autowired
    private CostDetailService costDetailService;
    @Autowired
    private CostLogService costLogService;

    @Value("${url.api.postApplyApi}")
    private String postApplyApi;

    @Value("${url.my.costApplyCallbackUrlPost}")
    private String costApplyCallbackUrlPost;

    @Value("${url.my.costCashierCallbackUrlPost}")
    private String costCashierCallbackUrlPost;

    @Value("${url.my.lendCostApplyCallBackUrlPost}")
    private String lendCostApplyCallBackUrlPost;

    @Value("${url.my.lendCostCashierCallbackUrlPost}")
    private String lendCostCashierCallbackUrlPost;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    /**
     * 获取财务审核系统费用单列表
     * @param request
     * @param response
     * @return
     */
    @GetMapping("getCostCheckList")
    public Map<String,Object> getCostCheckList(HttpServletRequest request, HttpServletResponse response){
        AxiosUtil.setCors(response,request);

        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        String costStatus = request.getParameter("costStatus");

        Map<String, Object> result = costService.getCostByStatus(Integer.parseInt(pageNum),Integer.parseInt(pageSize),Integer.parseInt(costStatus));
        result.put("msg","sussecc");

        return result;
    }

    /**
     * 审核通过
     * @param request
     * @param response
     * @return
     */
    @PostMapping("pass")
    public Map<String,Object> pass(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> map = null;
        String costNo = request.getParameter("costNo");
        String updateuserid = request.getParameter("updateuserid");
        Integer costStatus = costService.getCostStatusByNo(costNo);
        /**
         * 吴通新增
         * 如果是支付状态, 就不准改
         */
        if (null != costStatus && costStatus.equals(4)) {
            map = new HashMap<>();
            map.put("msg","error");
            map.put("result",0);
            map.put("finance",false);
            costLogService.save(costNo,Integer.parseInt(updateuserid),"尝试修改已支付费用单,被拦截");
            return  map;
        }

        costLogService.save(costNo,Integer.parseInt(updateuserid),"费用系统财务审核通过");

        // 审核通过，自动提交到出纳付款
        boolean toFinance = tofinanceMethod(costNo);
        if (toFinance){
            costLogService.save(costNo,Integer.parseInt(updateuserid),"出纳自动审核通过");
            map = changeStatus(costNo, 2);
        }else {
            costLogService.save(costNo,Integer.parseInt(updateuserid),"出纳审核失败");
            map = new HashMap<>();
        }
        map.put("finance",toFinance);
        return map;
    }

    /**
     * 驳回审核
     * @param request
     * @param response
     * @return
     */
    @PostMapping("reject")
    public Map<String,Object> reject(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        String rejectReason = request.getParameter("rejectReason");
        String updateuserid = request.getParameter("updateuserid");
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setRejectReason(rejectReason);
        Map<String, Object> stringObjectMap = costService.upadateCost(costDomain);
        Map<String, Object> map = changeStatus(costNo, 3);
        costLogService.save(costNo,Integer.parseInt(updateuserid),"费用系统财务审核驳回："+rejectReason);

        return map;

    }

    /**
     * 财务审核回调接口
     * @param request
     * @return
     */
    @PostMapping(value = "ApplyCallbackUrl",consumes ="application/json")
    public String applyCallbackUrl(HttpServletRequest request){
        String result = null;
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request)+" CostApplyCallbackUrl "+" 费用系统财务审核反馈信息获取失败");
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        line = line.replace("\\","");
        // 格式化为标准 json 格式
        int data = line.lastIndexOf("Data");
        int id = line.lastIndexOf("id");
        String substring1 = line.substring(0,data + 6);
        String substring2 = line.substring(data + 7, id - 4);
        String substring3 = line.substring(id - 3, line.length());
        line = substring1+substring2+substring3;
        line = line.toLowerCase();

        //保存为 bean,并且将反馈信息保存到数据库
        ObjectMapper mapper = new ObjectMapper();
        ApplyCallbackUrlVo applyCallbackUrlVo = null;
        try {
            applyCallbackUrlVo = mapper.readValue(line, ApplyCallbackUrlVo.class);
            if (null == applyCallbackUrlVo){
                logger.error("保存财务审核信息发生错误："+line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            // 执行保存反馈信息流程
            CostApplycallbackDomain applycallbackDomain = new CostApplycallbackDomain();
            BeanUtils.copyProperties(applyCallbackUrlVo.getData().getData(),applycallbackDomain);
            String costNo = applyCallbackUrlVo.getId().toUpperCase();
            if (null != costNo && costNo.contains("-")){
                costNo = costNo.split("-")[0];
            }
            applycallbackDomain.setCostNo(costNo);
            applycallbackDomain.setMessage(applyCallbackUrlVo.getData().getMessage().toUpperCase());
            applycallbackDomain.setApplyno(applycallbackDomain.getApplyno().toUpperCase());
            Integer integer = costApplycallbackService.saveApplycallbackResponse(applycallbackDomain);
            logger.warn("保存财务审核信息成功："+integer+"    "+line);
        } catch (IOException e) {
            logger.error("保存财务审核信息发生错误："+line);
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        result = "{result:true,msg:\"\"}";
        return result;
    }

    /**
     * 财务付款回调接口
     * @param request
     * @return
     */
    @PostMapping(value = "CashierCallbackUrl",consumes ="application/json")
    public String cashierCallbackUrl(HttpServletRequest request) {
        String result = null;
        // 将状态改为审核通过、已付款
        logger.warn("费用系统出纳回调"+IpUtil.getIpAddr(request) + " CashierCallbackUrl ");

        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()));
            line = br.readLine();
            line = line.replace("\\","");

            // 格式化为标准 json 格式
            int data = line.lastIndexOf("Data");
            int id = line.lastIndexOf("id");
            String substring1 = line.substring(0,data + 6);
            String substring2 = line.substring(data + 7, id - 4);
            String substring3 = line.substring(id - 3, line.length());
            line = substring1+substring2+substring3;
            line = line.toLowerCase();
            line = line.replace("_","");
            logger.warn("费用系统支付反馈信息："+line);

            ObjectMapper mapper = new ObjectMapper();
            CashierCallbackUrlVo cashierCallbackUrlVo = null;
            CostCashiercallbackDomain costCashiercallbackDomain = new CostCashiercallbackDomain();
            BigDecimal toRmbRate = null; // 转人民币汇率
            try {
                cashierCallbackUrlVo = mapper.readValue(line,CashierCallbackUrlVo.class);
                if (cashierCallbackUrlVo == null){
                    logger.error("费用系统保存出纳付款信息发生错误："+line);
                    result = "{result:false,msg:\"发生错误\"}";
                    return result;
                }
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData(),costCashiercallbackDomain);
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData(),costCashiercallbackDomain);
                BeanUtils.copyProperties(cashierCallbackUrlVo.getData().getData().getPaydetail(),costCashiercallbackDomain);
                String costNo = cashierCallbackUrlVo.getId().toUpperCase();
                if (null != costNo && costNo.contains("-")){
                    String[] split = costNo.split("-");
                    costNo=split[0];
                }
                costCashiercallbackDomain.setCostNo(costNo);
                costCashiercallbackDomain.setMessage(costCashiercallbackDomain.getMessage().toUpperCase());
                costCashiercallbackDomain.setPayno(costCashiercallbackDomain.getPayno().toUpperCase());

                // 被出纳驳回
                if (costCashiercallbackDomain.getMessage().contains("被驳回")){
                    boolean b = finansysReject(costCashiercallbackDomain);
                    if (b){
                        logger.info("出纳驳回，费用单状态更改成功"+costCashiercallbackDomain);
                        costLogService.save(costNo, costCashiercallbackDomain.getPayuserid(),"被出纳驳回："+costCashiercallbackDomain.getPaynote());
                    }else {
                        logger.info("出纳驳回，费用单状态更改失败"+costCashiercallbackDomain);
                    }
                    result = "{result:true,msg:\"出纳驳回\"}";
                    return result;
                }else{
                    // 获取xx货币-->CNY的汇率
                    toRmbRate = CurUtils.getCur(costCashiercallbackDomain.getCashierunitcode().toUpperCase(), "CNY", getExchangeRateApi);
                    costCashiercallbackDomain.setToRmbRate(toRmbRate);
                }

                //  保存出纳付款记录
                Integer integer = costCashiercallbackService.saveCostCashiercallbackResponse(costCashiercallbackDomain);
                logger.warn("保存出纳付款信息成功："+integer+"   "+costCashiercallbackDomain);
            } catch (IOException e) {
                logger.error("保存出纳付款信息发生错误："+line);
                result = "{result:false,msg:\"发生错误\"}";
                return result;
            }
            //  付款成功，更改费用单信息，否则返回失败
            CostDomain costDomain = costService.getCostDomainByNo(costCashiercallbackDomain.getCostNo());
            costDomain.setCostStatus(4);
            if (null != costDomain && null != costDomain.getIsLend()){
                if (costDomain.getIsLend() == 1){
                    costDomain.setLendStatus(1);
                }
            }
            costDomain.setPayUserId(costCashiercallbackDomain.getPayuserid());
            costDomain.setPayTime(new Date());
            costDomain.setAmountRmb(costCashiercallbackDomain.getCashierpaymoneyrmb());
            costDomain.setToRmbRate(toRmbRate);
            Map<String, Object> map = costService.upadateCost(costDomain);

            if (null != map ) {
                result = "{result:true,msg:\"保存成功\"}";
                costLogService.save(costCashiercallbackDomain.getCostNo(), costCashiercallbackDomain.getPayuserid(),"出纳收/付款成功："+costCashiercallbackDomain.getPaynote());
            }else {
                result = "{result:false,msg:\"发生错误\"}";
            }
        } catch (IOException e) {
            logger.error(IpUtil.getIpAddr(request)+" CashierCallbackUrl "+" 出纳付款反馈信息获取失败");
            result = "{result:false,msg:\"发生错误\"}";
            return result;
        }
        return result;
    }

    /**
     * 出纳驳回
     * @param domain
     * @return
     */
    private boolean finansysReject(CostCashiercallbackDomain domain) {
        // 保存驳回信息
        Integer integer = costCashiercallbackService.saveCostCashiercallbackResponse(domain);
        if (null != integer && integer >= 1) {
            // 费用单状态改为审核驳回，添加驳回理由
            // 修复驳回后提交出现费用单已存在的问题
            // 将后缀添加到  detail_key 字段
            CostDomain oldCost = costService.getByNo(domain.getCostNo());
            String oldDetailKey = oldCost.getDetailKey();
            CostDomain costDomain = new CostDomain();
            costDomain.setId(oldCost.getId());
            if (null !=oldDetailKey && oldDetailKey.contains("-")) {
                String[] split = oldDetailKey.split("-");
                if (null != split && split.length > 1) {
                    Integer i = Integer.parseInt(split[1]) + 1;
                    costDomain.setDetailKey(split[0] + "-" + i);
                }
            } else {
                costDomain.setDetailKey(oldCost.getCostNo() + "-" + 1);
            }
            costDomain.setRejectReason(domain.getPaynote());
            costDomain.setCostStatus(3);
            Integer result = costService.updateById(costDomain);
//            if (null != result && result >= 1) {
                // 如果是付款费用，改变子项目的费用单
//                if (1 == oldCost.getCostForm()) {
//                    List<CostDetailDomain> costDetailListByCostNo = costDetailService.getCostDetailListByCostNo(oldNo);
//                    if (null != costDetailListByCostNo && costDetailListByCostNo.size() >= 1){
//                        for (CostDetailDomain detail: costDetailListByCostNo){
//                            detail.setCostNo(costDomain.getCostNo());
//                            costDetailService.update(detail);
//                        }
//                    }
//                }

//            }
        }
        return true;
    }

    /**
     * 改变费用单状态
     * @param costNo
     * @param costStatus
     * @return
     */
    private Map<String,Object> changeStatus(String costNo,Integer costStatus){
        CostDomain costDomain = costService.getCostDomainByNo(costNo);
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(costStatus);
        if(costStatus == 2){
            costDomain.setAuditTime(new Date());
        }
        if (null != costDomain && null != costDomain.getIsLend()){
            if (1 == costDomain.getIsLend() && 4 == costStatus){
                costDomain.setLendStatus(1);
            }
        }
        Map<String, Object> map = costService.upadateCost(costDomain);

        return map;

    }


    /**
     * 提交出纳系统
     * @param costNo
     * @return
     */
    public boolean tofinanceMethod(String costNo){
        // 获取费用单信息
        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        CostDomain cost = costService.getCostDomainByNo(costNo);

        CostCompanyDomain companyByCompanyNo = costCompanyService.getCompanyByCompanyNo(cost.getCompanyNo());

        //  提交财务
        MultiValueMap<String, Object> requestEntity = new LinkedMultiValueMap<>();

        requestEntity.add("CompanyMainName", cost.getCompanyName()); // 公司主体(CompanyMainName)不可为空；
        // 借支单补差额的付款单，单独设置回调地址；
        requestEntity.add("Title",cost.getCostNo());
        if (costNo.startsWith("S")){
            logger.info("补差额的付款单："+costNo);
            applyMoneyDetail.setName("借支单补差额");
            requestEntity.add("ApplyCallbackUrl", lendCostApplyCallBackUrlPost); // 审核回调地址(ApplyCallbackUrl)不可为空；
            requestEntity.add("CashierCallbackUrl", lendCostCashierCallbackUrlPost); // 出纳回调地址(CashierCallbackUrl)不可为空；

        }else {
            requestEntity.add("ApplyCallbackUrl", costApplyCallbackUrlPost); // 审核回调地址(ApplyCallbackUrl)不可为空；
            requestEntity.add("CashierCallbackUrl", costCashierCallbackUrlPost); // 出纳回调地址(CashierCallbackUrl)不可为空；
        }
        requestEntity.add("UnitCode", cost.getDic()); // 币种编号(UnitCode)不可为空；
        requestEntity.add("UnitName", cost.getDic()); // 币种名称(UnitName)不可为空；
        // 交易对象改为付款/收款单位
        requestEntity.add("TradeObjectID", companyByCompanyNo.getValue() + "");
        requestEntity.add("TradeObjectName", cost.getBankCompany() + ""); // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        requestEntity.add("BankNameto", "" + cost.getBankName());
        requestEntity.add("BankCardto", "" + cost.getBankCard());
        requestEntity.add("BankCardUserto", "" + cost.getBankCardUser()); // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        requestEntity.add("SourceCode", "newCost");
        requestEntity.add("SourceTypeCode", "newCostType"); // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        // 账期 0 PayDay
        requestEntity.add("PayDay", 0);
        // 预计付款时间 ExpectPayTime
        requestEntity.add("ExpectPayTime", new Date());

        applyMoneyDetail.setMoney(cost.getAmount());
        applyMoneyDetail.setMoneyRmb(cost.getAmount());

        if (1 == cost.getCostForm()) {
            requestEntity.add("ApplyType", "" + 1); // 申请类型(ApplyType)不存在；申请类型:1#付款;2#收款;3#无需付款;
            applyMoneyDetail.setName("费用单付款");
        }else if (2 == cost.getCostForm()){
            requestEntity.add("ApplyType", "" + 2); // 申请类型(ApplyType)不存在；申请类型:1#付款;2#收款;3#无需付款;
            applyMoneyDetail.setName("费用单收款");
        }else if (3 == cost.getCostForm() && 1 == cost.getIsLend()){
            requestEntity.add("ApplyType", "" + 1); // 申请类型(ApplyType)不存在；申请类型:1#付款;2#收款;3#无需付款;
            applyMoneyDetail.setName("借支单付款");
        }
        requestEntity.add("UserAcctID", "" + cost.getCreateUserid());
        requestEntity.add("UserAcctName", "" + cost.getCreateUsername()); // 申请人(UserAcctID/UserAcctName)不存在；

        applyMoneyDetail.setRemark("");
        applyMoneyDetailList.add(applyMoneyDetail);

        requestEntity.add("MoneyDetail", applyMoneyDetailList); // 出纳申请金额明细(MoneyDetail)不可为空；

        // 设置 detailKey
        String detailKey = cost.getDetailKey();
        if (null == detailKey || !detailKey.contains("F")){
            detailKey = cost.getCostNo();
        }
        requestEntity.add("DetailKey", detailKey); // 回调必要的key参数（DetailKey）不能为空；
        // 吴通 增加费用大类
        requestEntity.add("TypeName", cost.getTypeName());
        Map<String, Object> map = requestEntity.toSingleValueMap();
        String s = JSON.toJSONString(map);
        logger.info(cost.getCostNo()+" 费用单提交财务审核信息："+s);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<String> entity = new HttpEntity<String>(s, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(postApplyApi, entity, String.class);
        logger.info(cost.getCostNo()+" 费用单提交审核反馈信息："+response);

        String strBody = null;
        if (null != response && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
            strBody = strBody.replace("\\", "");
            strBody = strBody.toLowerCase();
            if (strBody.contains("申请单已存在")) {
                logger.info(cost.getCostNo()+" 申请单已存在：" + strBody);
                return true;
            } else if (strBody.contains("创建")) {
                //  将 strBody 保存到数据库 costTofinance 表
                ObjectMapper mapper = new ObjectMapper();
                try {
                    //  将 strBody 转作为标准 JSONString 格式
                    int i = strBody.lastIndexOf("data\":");
                    String substring1 = strBody.substring(0, i + 6);
                    String substring2 = strBody.substring(i + 7, strBody.length() - 2);
                    strBody = substring1 + substring2 + "}";
                    logger.warn(strBody);
                    ApplyCallbackVo applyCallbackVo = mapper.readValue(strBody, ApplyCallbackVo.class);

                    // 将反馈信息保存到数据库
                    if (null != applyCallbackVo && applyCallbackVo.isSuccess()) {
                        CostTofinanceDomain costTofinanceDomain = new CostTofinanceDomain();
                        BeanUtils.copyProperties(applyCallbackVo.getData(), costTofinanceDomain);
                        costTofinanceDomain.setCostNo(cost.getCostNo().toUpperCase());
                        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
                        // 执行 insert 流程
                        Integer integer = costTofinanceService.saveCostTofinanceMsg(costTofinanceDomain);
                        return true;
                    }
                } catch (IOException e) {
                    logger.error("财务审核申请单信息保存到数据库失败" + strBody);
                    return false;
                }

            }
        }
        return false;
    }
    // ================================== 结束费用 ======================================================
    @PostMapping("finish")
    public Map<String,Object> finish(HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);

        String costNo = request.getParameter("costNo");
        Map<String, Object> map = changeStatus(costNo, 7);

        return map;
    }
    // ================================== 文件下载 ======================================================
    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String costNo = request.getParameter("costNo");
        String fileType = request.getParameter("fileType");
        Map<String, Object> costByCostNo = costService.getCostByCostNo(costNo);
        CostDto cost = (CostDto) costByCostNo.get("cost");
        String filePath = null;
        String fileName = null;
        if ("file".equals(fileType)){
            filePath = cost.getFilePath();
            fileName = cost.getFileName();
        }else if ("morFile".equals(fileType)){
            filePath = cost.getMorFilePath();
            fileName = cost.getMorFileName();
        }
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"),"iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    /**
     * 借支单结清
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/finishLend")
    public Map<String,Object> finishLend(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String costNo = request.getParameter("costNo");
        String updateuserid = request.getParameter("updateuserid");
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setLendStatus(4);
        result = costService.upadateCost(costDomain);
        result.put("success",true);
        result.put("msg","已结清");
        costLogService.save(costNo,Integer.parseInt(updateuserid),"操作结清");
        return result;
    }
}
