package com.blt.other.module.commons.controller;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.module.commons.service.IndexService;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/index")
@Api(tags = "首页接口")
public class IndexController {

    @Resource
    private IndexService indexService;

    @GetMapping("/getBuyPlanList")
    public Map<String, Object> getBuyPlanList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String userid = request.getParameter("userid");
        List<BuyPlanDto> buyPlanList = indexService.getBuyPlanList(Integer.parseInt(userid));
        Map<String, Object> result = new HashMap<>();
        result.put("buyPlanList", buyPlanList);
        result.put("success", true);
        return result;
    }

    @GetMapping("/getCostPlanList")
    public Map<String, Object> getCostPlanList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String userid = request.getParameter("userid");
        List<CostPlanDto> costPlanDtos = indexService.getCostPlanList(Integer.parseInt(userid));
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanList", costPlanDtos);
        result.put("success", true);
        return result;
    }

    @ApiOperation("费用计划列表，condition=lt(小于)/le(小于等于)/eq(登宇)/ne(不等于)/ge(大于等于)/gt(大于)/in(包含)/notIn(不包含)，statusList优先级大于status")
    @GetMapping("/costPlanList")
    public Map<String, Object> costPlanList(Integer userid,
                                        Integer status,
                                        String condition,
                                        @RequestParam(value = "statusList", required = false) List<Integer> statusList,
                                        Integer limit) {
        List<CostPlanDto> costPlanDtos = null;
        costPlanDtos = indexService.getCostPlanList(userid, status, condition, statusList, limit);
        Map<String, Object> result = new HashMap<>();
        result.put("costPlanList", costPlanDtos);
        result.put("success", true);
        return result;
    }

    @GetMapping("/getCostList")
    public Map<String, Object> getCostList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String userid = request.getParameter("userid");
        List<CostDto> costDtos = indexService.getCostList(Integer.parseInt(userid));
        Map<String, Object> result = new HashMap<>();
        result.put("costList", costDtos);
        result.put("success", true);
        return result;
    }

    @ApiOperation("费用列表，condition=lt(小于)/le(小于等于)/eq(登宇)/ne(不等于)/ge(大于等于)/gt(大于)/in(包含)/notIn(不包含)，statusList优先级大于status")
    @GetMapping("/costList")
    public Map<String, Object> costList(Integer userid,
                                        Integer status,
                                        String condition,
                                        @RequestParam(value = "statusList", required = false) List<Integer> statusList,
                                        Integer limit) {
        List<CostDto> costDtos = null;
        try {
            costDtos = indexService.getCostList(userid, status, condition, statusList, limit);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Map<String, Object> result = new HashMap<>();
        result.put("costList", costDtos);
        result.put("success", true);
        return result;
    }
}
