package com.blt.other.module.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.dto.request.AddDepartmentReviewerReq;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.request.ModifyDepartmentReviewerReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import com.blt.other.module.sys.service.IDepartmentReviewerService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 部门审核人 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
@Service
public class DepartmentReviewerServiceImpl extends ServiceImpl<DepartmentReviewerMapper, DepartmentReviewer> implements IDepartmentReviewerService {

    @Resource
    CostReviewerMapper costReviewerMapper;

    @Override
    public IPage<DepartmentReviewerListItem> departmentReviewerList(DepartmentReviewerListReq req) {
        IPage<DepartmentReviewerListItem> page = new Page<>(req.getPageNum(), req.getPageSize());
        Map<Integer, List<CostReviewer>> cMap = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .in(CostReviewer::getReferId, page.getRecords().stream().map(DepartmentReviewerListItem::getId).collect(Collectors.toList())))
                .stream()
                .collect(Collectors.groupingBy(CostReviewer::getReferId));

        page.getRecords().forEach(departmentReviewerListItem -> {
            departmentReviewerListItem.setCostReviewerList(cMap.get(departmentReviewerListItem.getId()));
        });

        return baseMapper.departmentReviewerList(page, req);
    }

    @Override
    public void modifyDepartmentReviewer(ModifyDepartmentReviewerReq req) {
        DepartmentReviewer departmentReviewer = this.getById(req.getId());
    }

    @Override
    public void addDepartmentReviewer(AddDepartmentReviewerReq req) {

    }
}
