package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class HrCheckState extends CostState {

    @Autowired
    FinancialCheckState financialCheckState;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostCompanyDao costCompanyDao;

    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //如果不需要审核 直接通过
        if (!costTemplate.shouldHrCheck(costDomain)) {

            costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);

            //流转状态
            nextState(financialCheckState);
            costSubscribe.subscribe(costContext);
//            costLogService.saveByManage(costDomain.getCostNo(), "行政审核自动通过", CostLogDomain.DEPARTMENT_AUTO_PASS);

            return;
        }

        //人工审核
        if (costContext.currentUserId != null) {
            //人工审核通过
            if (!costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
                costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);
                costDomain.setLastModifyDate(LocalDateTime.now());
                costDao.updateById(costDomain);
                costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核通过", CostLogDomain.HR_PASS);

                nextState(financialCheckState);
                //发布到总线尝试下个环节的自动审核
                costSubscribe.subscribe(costContext);
            }
            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }


    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;


        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_HR_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核没权限
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        if (!costCurrentReviewerService.canAudit(currentUserId, costDomain.getCostNo())) {
            throw new BizRuntimeException("current user no authority");
        }


        costLogService.save(costDomain.getCostNo(), currentUserId, "行政审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

        //sd
        costContext.costService.reject(costDomain.getCostNo());

    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //如果不需要审核 直接通过
        if (costTemplate.shouldHrCheck(costDomain)) {
            OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());

            List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId())
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer));

            costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(),costReviewerList);
            costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "行政审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));

        }

    }
}
