package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.cost.CostServiceFactory;

/**
 * <p>
 * 费用单上下文
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:52 下午
 */
public class CostContext {


    public void setCostState(CostState costState) {
        this.costState = costState;
        this.costState.setCostContext(this);
    }

    protected CostState costState;


    protected CostService costService;
    protected CostDomain costDomain;
    protected Integer currentUserId;


    public CostContext(String costNo, Integer currentUserId) {
        this.costService = CostServiceFactory.getCostService(costNo);
        this.currentUserId = currentUserId;
        this.costDomain = costService.getCostByCostNo(costNo);
    }


    public void handle() {
        costState.updateCurrentReviewer();
        costState.handle();
    }

    public void refuse(String rejectReason) {
        costState.refuse(rejectReason);
    }

}
