package com.blt.other.module.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostLogDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.UserDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class CostLogServiceImpl implements CostLogService {

    @Autowired
    private CostLogDao costLogDao;
    @Autowired
    private UserDao userDao;


    @Override
    public Integer save(String costNo, Integer updateUserid, String updateMainNote) {
        return this.save(costNo, updateUserid, updateMainNote, null);
    }

    @Override
    public Integer save(String costNo, Integer updateUserid, String updateMainNote, Integer type) {
        CostLogDomain costLog = new CostLogDomain();
        costLog.setCostNo(costNo);
        costLog.setUpdateTime(new Date());

        UserDomain user = userDao.selectByuserid(updateUserid);


        costLog.setUpdateUsercode(user.getUsercode());
        costLog.setUpdateUsername(user.getUsername());
        costLog.setUpdateUserid(updateUserid);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        costLog.setUpdateNote(sdf.format(costLog.getUpdateTime()) + "  " + updateMainNote + "  更新人：" + user.getUsername());
        costLog.setType(type);
        return costLogDao.insert(costLog);
    }

    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostDao costDao;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    CostCompanyDao costCompanyDao;

    @Override
    public void saveByManage(String costNo, String updateMainNote, Integer type) {
        CostLogDomain costLog = new CostLogDomain();
        costLog.setCostNo(costNo);
        costLog.setUpdateTime(new Date());

        CostDomain costDomain = costDao.selectByCostNo(costNo);

        OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());
        OaUser reviewer;
        if (type.equals(CostLogDomain.DEPARTMENT_AUTO_PASS)) {
            reviewer = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                    .eq(CostReviewer::getReferId, costUser.getPrimaryDepartmentId()))
                    .stream()
                    .limit(1)
                    .findAny()
                    .map(costReviewer -> oaUserMapper.selectByOaUserId(costReviewer.getReviewerUserId()))
                    .orElse(OaUser.DEFAULT);
        } else if (type.equals(CostLogDomain.FINANCIAL_AUTO_PASS)) {
            reviewer = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompany.getId()))
                    .stream()
                    .limit(1)
                    .findAny()
                    .map(costReviewer -> oaUserMapper.selectByOaUserId(costReviewer.getReviewerUserId()))
                    .orElse(OaUser.DEFAULT);
        } else if (type.equals(CostLogDomain.FINAL_AUTO_PASS)) {
            reviewer = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompany.getId()))
                    .stream()
                    .limit(1)
                    .findAny()
                    .map(costReviewer -> oaUserMapper.selectByOaUserId(costReviewer.getReviewerUserId()))
                    .orElse(OaUser.DEFAULT);
        } else {
            throw new BizRuntimeException("invalid param");
        }

        costLog.setUpdateUsercode(reviewer.getUserCode());
        costLog.setUpdateUsername(reviewer.getUserName());
        costLog.setUpdateUserid(reviewer.getOaUserId());

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        costLog.setUpdateNote(sdf.format(costLog.getUpdateTime()) + "  " + updateMainNote + "  更新人：" + reviewer.getUserName());
        costLog.setType(type);
        costLogDao.insert(costLog);
    }

    @Override
    public List<CostLogDomain> getListByCostNo(String costNo) {
        return costLogDao.selectByCostNo(costNo);
    }

    @Override
    public List<String> getListLogs(List<CostLogDomain> logs) {
        if (null != logs && logs.size() >= 1) {
            List<String> list = new ArrayList<>();
            for (CostLogDomain domain : logs) {
                list.add(domain.getUpdateNote());
            }
            return list;
        }
        return null;
    }
}
