package com.blt.other.module.cost.service.impl;

import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.dao.CostExpDao;
import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.module.cost.service.CostDetailService;
import com.blt.other.module.cost.service.CostExportService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.CostExportVo;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.database.model.CostExpDomain;
import com.blt.other.database.model.UserDomain;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Service
public class CostExportServiceImpl implements CostExportService {
    @Autowired
    private CostDao costDao;
    @Autowired
    private CostService costService;
    @Autowired
    private CostExpDao costExpDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private CostDetailDao costDetailDao;
    @Autowired
    private CostDetailService costDetailService;

    @Override
    public String exportFees(List<String> exportNos) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("费用表");
        List<CostDto> exportList = getExportList(exportNos);
        if (null == exportList || exportList.size() < 1) {
            return null;
        }
        // 设置表头
        String[] headers = {"费用单号", "费用类型", "费用单大类", "费用单小类", "费用单状态", "借支/借还", "关联借支单号", "借支单状态", "是否抵个税", "付款主体", "收款单位", "付款理由", "付款金额", "币种", "创建人名称", "下单时间", "用途", "付款时间", "发票状态"
                , "项目", "客户编号"};
        HSSFRow row0 = sheet.createRow(0);
        for (int i = 0; i < headers.length; i++) {
            HSSFCell cell = row0.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue(text);
        }
        int rows = 1;
        for (CostDto costDto : exportList) {
            HSSFRow row = sheet.createRow(rows);
            row.createCell(0).setCellValue(costDto.getCostNo());
            row.createCell(2).setCellValue(costDto.getTypeName());
            row.createCell(3).setCellValue(costDto.getKindName());
            row.createCell(4).setCellValue(costDto.getCostStatusDto());
            row.createCell(9).setCellValue(costDto.getCompanyName());
            row.createCell(10).setCellValue(costDto.getBankCompany());
            row.createCell(11).setCellValue(costDto.getCostReason());
            row.createCell(14).setCellValue(costDto.getCreateUsername());
            // 日期格式更改
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(costDto.getCreateTime());
            row.createCell(15).setCellValue(time);
            row.createCell(16).setCellValue(costDto.getCostReason());
            if (costDto.getPayTime() != null) row.createCell(17).setCellValue(sdf.format(costDto.getPayTime()));
            if (1 == costDto.getCostForm()) {
                row.createCell(1).setCellValue("付款");
                if (null != costDto.getIsLend() && 2 == costDto.getIsLend()) {
                    row.createCell(1).setCellValue("差额单");
                    row.createCell(6).setCellValue(costDto.getSupCostNo());
                    row.createCell(12).setCellValue(costDto.getPayPlanAmountDto());
                    row.createCell(13).setCellValue(costDto.getPayDicDto());
                } else {
                    row.createCell(12).setCellValue(costDto.getAmountDto());
                    row.createCell(13).setCellValue(costDto.getDicDto());
                    row.createCell(8).setCellValue(costDto.getIsTaxStr());
                }
            }
            if (2 == costDto.getCostForm()) {
                row.createCell(1).setCellValue("收款");
                row.createCell(12).setCellValue(costDto.getAmountDto());
                row.createCell(13).setCellValue(costDto.getDicDto());
            }
            if (3 == costDto.getCostForm()) {
                row.createCell(5).setCellValue(costDto.getIsLendDto());
                if (1 == costDto.getIsLend()) {
                    row.createCell(1).setCellValue("借支");
                    row.createCell(7).setCellValue(costDto.getLendStatusDto());
                    row.createCell(12).setCellValue(costDto.getAmountDto());
                    row.createCell(13).setCellValue(costDto.getDicDto());
                }
                if (2 == costDto.getIsLend()) {
                    row.createCell(6).setCellValue(costDto.getSupCostNo());
                    row.createCell(1).setCellValue("借还");
                    row.createCell(12).setCellValue(costDto.getPayPlanAmountDto());
                    row.createCell(13).setCellValue(costDto.getPayDicDto());
                    if (costDto.getHasInvoice() == 1) {
                        row.createCell(18).setCellValue("已给");
                    } else {
                        row.createCell(18).setCellValue("未给");
                    }
                }
            }
            row.createCell(19).setCellValue(costDto.getProjectType());
            row.createCell(20).setCellValue(costDto.getCustomerNum());
            rows++;
        }
        // 保存到本地，并且返回路径
        String filePath = saveFile(workbook);
        return filePath;
    }

    @Override
    public CostExpDomain saveRecord(CostExportVo costExportVo, String filePath) {
        CostExpDomain costExpDomain = new CostExpDomain();
        costExpDomain.setExpList(costExportVo.getParams().getExportNos().toString());
        costExpDomain.setExpNo(createExpNo());
        costExpDomain.setExpPath(filePath);
        costExpDomain.setExpTime(new Date());
        UserDomain user = userDao.selectByuserid(costExportVo.getParams().getUserid());
        costExpDomain.setExpUserid(costExportVo.getParams().getUserid());
        costExpDomain.setExpUsername(user.getUsername());
        Integer insert = costExpDao.insert(costExpDomain);
        if (null != insert && insert >= 1) {
            return costExpDomain;
        }
        return null;
    }

    @Override
    public String createExpNo() {
        String expNo = "EXP" + System.currentTimeMillis();
        CostExpDomain exp = costExpDao.selectByExpNo(expNo);
        while (null != exp) {
            expNo = "EXP" + System.currentTimeMillis();
            exp = costExpDao.selectByExpNo(expNo);
        }
        return expNo;
    }

    @Override
    public CostExpDomain getByExpNo(String expNo) {
        CostExpDomain costExpDomain = costExpDao.selectByExpNo(expNo);
        return costExpDomain;
    }

    private String saveFile(HSSFWorkbook workbook) {
        // 文件名
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = "fee" + sdf.format(new Date()) + ".xls";
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("export/cost/");
        filePath = filePath + UUID.randomUUID() + "&" + fileName;
        File dest = new File(filePath);
        // 创建路径
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        // 生成 excel 文件
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            workbook.write(fos);
            fos.flush();
            fos.close();
        } catch (IOException e) {
            return null;
        }
        return filePath;
    }

    private List<CostDto> getExportList(List<String> exportNos) {
        List<CostDto> exportList;
        // 获取要导出的费用列表
        if (null != exportNos && exportNos.size() >= 1) {
            exportList = new ArrayList<>();
            for (String costNo : exportNos) {
                CostDto costDtoByNo = costDao.selectByCostNo(costNo).castToDto();
                if (1 == costDtoByNo.getCostForm()) {
                    // 付款单，将子项目赋值到 CostDto 逐一打印
                    List<CostDetailDomain> costDetailDomains = costDetailDao.selectListByCostNo(costNo);
                    if (null != costDetailDomains && costDetailDomains.size() >= 1) {
                        for (CostDetailDomain detail : costDetailDomains) {
                            CostDto cost = new CostDto();
                            BeanUtils.copyProperties(costDtoByNo, cost);
                            BeanUtils.copyProperties(detail, cost);
                            cost.setAmountDto("" + cost.getAmount().setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
                            if (null != costDtoByNo.getIsLend() && 2 == costDtoByNo.getIsLend()) {
                                cost.setPayPlanAmountDto("" + cost.getPayPlanAmount().setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
                            }
                            exportList.add(cost);
                        }
                    }
                } else {
                    costDtoByNo.setAmountDto("" + costDtoByNo.getAmount().setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
                    if (3 == costDtoByNo.getCostForm() && 2 == costDtoByNo.getIsLend()) {
                        costDtoByNo.setPayPlanAmountDto("" + costDtoByNo.getPayPlanAmount().setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
                    }
                    exportList.add(costDtoByNo);
                }
            }
        } else {
            return null;
        }
        return exportList;
    }
}
