package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.cost.dto.request.*;
import com.blt.other.module.cost.model.SpecDepartmentCheckConfig;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
public interface ISpecDepartmentCheckConfigService extends IService<SpecDepartmentCheckConfig> {

    /**
     * 分页查询特殊审核人
     *
     * @param req req
     * @return res
     */
    Page<SpecDepartmentCheckConfig> queryPage(SpecDepartmentCheckQueryPageReq req);

    /**
     * 批量设置特殊审核人
     *
     * @param req req
     */
    void batchUpdateReviewer(BatchUpdateReviewerReq req);

    /**
     * 新增特殊审核数据
     *
     * @param req req
     */
    void add(SpecDepartmentCheckAddReq req);

    /**
     * importExcel
     *
     * @param req req
     */
    void importExcel(SpecDepartmentCheckImportExcelReq req) throws IOException;

    /**
     * 导出excel
     *
     * @param response response
     * @param req req
     */
    void exportExcel(HttpServletResponse response, SpecDepartmentCheckExportExcelReq req) throws IOException;
}
