package com.blt.other.module.auth.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.auth.model.OaDepartment;
import org.springframework.lang.NonNull;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface IOaDepartmentService extends IService<OaDepartment> {


    /**
     * <p>
     * 获取百伦公司主体下面的一级部门列表
     * </p>
     *
     * @param companyId 公司主体id
     * @return 一级部门列表
     */
    List<OaDepartment> oaDepartment(@NonNull Integer companyId);


    /**
     * <p>
     * 获取部门审核人列表
     * </p>
     *
     * @return 部门审核人列表
     */
    IPage<DepartmentReviewerListItem> reviewerList(DepartmentReviewerListReq req);

    /**
     * <p>
     * 修改部门审核人
     * </p>
     *
     * @param userId                    当前用户id
     * @param oaDepartmentId            oa部门id
     * @param departmentReviewerUserIds 部门审核oa userid list
     */
    void modifyDepartmentReviewer(Integer userId, Integer oaDepartmentId, List<Integer> departmentReviewerUserIds);

    /**
     * 更新部门审核金额
     *
     * @param oaDepartmentId oa部门id
     * @param amount         金额
     */
    void updateDepartmentMinimumReviewAmount(Integer oaDepartmentId, BigDecimal amount);
}
