package com.blt.other.database.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@TableName(value = "cost_type")
public class CostTypeDomain {

    //费用类型 包括付款 借还
    public static final Integer feeType = 0b1001;
    //收入类别 包括收款
    public static final Integer incomeType = 0b0100;
    //借支类别 包括借支
    public static final Integer borrow = 0b0010;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("费用类型编号")
    private String typeNo;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("费用类型标题")
    private String typeName;

    private String accountingSubjectNo;

    /**
     * 形如0b1001 四位二进制
     * 高位到低位分别是 付款 收款 借支 借还
     */
    @ApiModelProperty("费用模版类型作用")
    private Integer costTemplateType;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人id")
    private Integer updateUserId;

    @ApiModelProperty(value = "更新人")
    private String updateUser;

    @ApiModelProperty(value = "最后更新时间")
    private LocalDateTime lastUpdateTime;

}

