package com.blt.other.module.sku.dao;

import com.blt.other.database.model.SkuKindDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface SkuKindDao {

    /**
     * 添加 sku 大类
     * @param skuKindDomain
     * @return
     */
    Integer insert(SkuKindDomain skuKindDomain);

    /**
     * 根据编号获取 sku 大类
     * @param skuKindNo
     * @return
     */
    SkuKindDomain selectBySkuKindNo(String skuKindNo);

    /**
     *
     * 根据 skuKindName skuTypeNo 获取 sku 小类
     * @return
     */
    List<SkuKindDomain> selectBySkuKindNameAndSkuTypeNo(SkuKindDomain skuKindDomain);

    /**
     * 获取所有 sku 小类
     * @return
     */
    List<SkuKindDomain> selectAll();

    /**
     * 根据 skutypeno 获取 sku 小类
     * @return
     */
    List<SkuKindDomain> selectBySkuTypeNo(String skuTypeNo);

}
