package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.sys.dto.request.CompanyReviewerListReq;
import com.blt.other.module.sys.dto.request.CostReviewerExportReq;
import com.blt.other.module.sys.dto.request.CostReviewerImportReq;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface CostCompanyService extends IService<CostCompanyDomain> {

    /**
     * 从财务系统同步主体
     *
     * @return
     */
    String syncCompany();

    /**
     * 获取所有主体
     *
     * @return
     */
    List<CostCompanyDomain> getAllCompany();


    List<CostCompanyDomain> getAllCompanyAuthority();


    /**
     * <p>
     * 查询财务审核人和最终审核人配置
     * </p>
     *
     * @param req req
     * @return 财务审核人和最终审核人配置
     */
    IPage<CostCompanyDomain> reviewerList(CompanyReviewerListReq req);


    /**
     * <p>
     * 修改最终审核人
     * </p>
     *
     * @param userId              当前用户oa userid
     * @param companyNoList       公司财务主体自编No list
     * @param finalReviewerUserId 最终审核核人oa userid
     */
    void modifyFinalReviewer(Integer userId, List<String> companyNoList, Integer finalReviewerUserId);

    /**
     * <p>
     * 修改财务审核人
     * </p>
     *
     * @param userId                      当前用户oa userid
     * @param companyNoList               公司财务主体自编No list
     * @param financialReviewerUserIdList 财务审核核人oa userid
     */
    void modifyFinancialReviewer(Integer userId, List<String> companyNoList, List<Integer> financialReviewerUserIdList);

    /**
     * <p>
     * 修改行政审核
     * </p>
     *
     * @param userId               当前用户oa userid
     * @param companyNoList        公司财务主体自编No list
     * @param hrReviewerUserIdList 财务审核核人oa userid
     */
    void modifyHrReviewer(Integer userId, List<String> companyNoList, List<Integer> hrReviewerUserIdList);


    /**
     * 财务主体字典 缓存
     *
     * @return 财务主体字典
     */
    Map<String, CostCompanyDomain> costCompanyMap();

    void importExcel(CostReviewerImportReq req);

    void exportExcel(HttpServletResponse response, CostReviewerExportReq req);
}
