package com.blt.other.module.commons.service.impl;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.database.model.BuyPlanDomain;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.module.commons.dao.IndexDao;
import com.blt.other.module.commons.service.IndexService;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.service.BuyPlanService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class IndexServiceImpl implements IndexService {

    @Resource
    private IndexDao indexDao;
    @Resource
    private BuyPlanService buyPlanService;

    @Override
    public List<BuyPlanDto> getBuyPlanList(Integer userid) {
        List<BuyPlanDomain> buyPlanDomains = indexDao.selectBuyPlanList(userid);
        return buyPlanService.getDtoList(buyPlanDomains);
    }

    @Override
    public List<CostPlanDto> getCostPlanList(Integer userid) {
        List<CostPlanDomain> costPlanDomains = indexDao.selectCostPlanList(userid);
        return costPlanDomains.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());
    }

    @Override
    public List<CostDto> getCostList(Integer userid) {
        List<CostDomain> costDomains = indexDao.selectCostList(userid);
        return costDomains.stream().map(CostDomain::castToDto).collect(Collectors.toList());
    }

}
