package com.blt.other.module.sys.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.sys.model.Role;
import com.blt.other.module.sys.service.IRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2021-03-10
 */
@Api(tags = "角色接口")
@RestController
@RequestMapping("/role")
public class RoleController {

    @Resource
    IRoleService roleService;

    @ApiOperation("新增角色")
    @PostMapping("/save")
    public CostResult<Void> save(@RequestBody Role role) {
        roleService.save(role);
        return CostResult.success();
    }

    @ApiOperation("分页查询")
    @PostMapping("/page")
    public CostResult<Page<Role>> page(@RequestBody Page<Role> page) {
        return CostResult.success(roleService.page(page));
    }

//    @ApiOperation("删除角色")
//    @PostMapping("/removeById")
//    public CostResult<Void> remove(@RequestParam Integer id) {
//        roleService.removeById(id);
//        return CostResult.success();
//    }

    @ApiOperation("更新角色")
    @PostMapping("/updateById")
    public CostResult<Void> updateById(@RequestBody Role role) {
        roleService.updateById(role);
        return CostResult.success();
    }

}
