package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.LogisticsFinansysDto;
import com.bailuntec.cost.api.dto.SubLogisticsFinansysDto;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.UserCostFinansysDomain;

import java.util.List;

public interface UserCostFinansysService {

    /**
     * 保存用户填写的财务信息
     *
     * @param userCostFinansysDomain 财务信息
     */
    void saveFinancesRecord(UserCostFinansysDomain userCostFinansysDomain);

    /**
     * <p>
     * 根据费用单信息构建财务信息
     * </p>
     *
     * @param planDomain 费用单计划
     * @return 财务信息
     */
    UserCostFinansysDomain createFinanceRecordByCostPlanDomain(CostPlanDomain planDomain);

    UserCostFinansysDomain getByUserCostFinancesNo(String userCostFinansysNo);

    UserCostFinansysDomain getByUserCostFinancesDetail(UserCostFinansysDomain userCostFinansysDomain);

    List<UserCostFinansysDomain> getAllFinancesRecord();

    String syncUserFinance();

    List<UserCostFinansysDomain> getByUserid(int parseInt);

    /**
     * 获取所有一级物流供应商财务信息
     *
     * @return
     */
    List<LogisticsFinansysDto> getAllLogisticsFinance();

    /**
     * 获取所有二级物流供应商财务信息
     *
     * @return
     */
    List<SubLogisticsFinansysDto> getAllSubLogisticsFinance();

}
