package com.blt.other.module.sku.controller;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.database.model.SkuTypeDomain;
import com.blt.other.database.model.SupplierDomain;
import com.blt.other.database.model.SysProductDomain;
import com.blt.other.module.sku.service.SkuTypeService;
import com.blt.other.module.sku.service.SysProductService;
import com.blt.other.module.sku.vo.SkuSaveVo;
import com.blt.other.module.supplier.service.SupplierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "sku")
public class SkuController {

    @Autowired
    private SysProductService sysProductService;
    @Autowired
    private SkuTypeService skuTypeService;
    @Autowired
    private SupplierService supplierService;


    /**
     * 获取所有 sku
     *
     * @return
     */
    @GetMapping(value = "getAllSkuList")
    public List<SysProductDomain> getAllSkuList() {
        return sysProductService.getAllSku();
    }

    /**
     * 分页获取所有 sku
     *
     * @return
     */
    @GetMapping(value = "getAllSku")
    public Map<String, Object> getAllSku(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        Map<String, Object> allSkuByPage = sysProductService.getAllSkuByPage(Integer.parseInt(pageNum), Integer.parseInt(pageSize));

        allSkuByPage.put("success", true);
        return allSkuByPage;
    }

    /**
     * 根据关键字获取 sku
     *
     * @param keyword
     * @return
     */
    @GetMapping(value = "getSkuListByKeyword/{keyword}")
    public List<SysProductDomain> getSkuListByKeyword(@PathVariable String keyword) {
        return sysProductService.getSkuByKeyword(keyword);
    }

    @PostMapping("/add/save")
    public Map<String, Object> save(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        result.put("success", false);
        result.put("msg", "参数为空");

        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames) {
            String params = parameterNames.nextElement();
            System.out.println(params);
            SkuSaveVo object = null;
            try {
                object = (SkuSaveVo) MyMapperUtil.getObject(params, SkuSaveVo.class);
                result.put("success", true);
                result.put("msg", "SKU 已保存");
            } catch (RuntimeException e) {
                result.put("msg", "格式不正确");
                return result;
            }
            if (null == object.getSku().getSkuTypeNo() || object.getSku().getSkuTypeNo().equals("")) {
                result.put("success", false);
                result.put("msg", "请选择 SKU 类型");
                return result;
            }
//            if (null == object.getSku().getSkuKindNo() || object.getSku().getSkuKindNo().equals("")){
//                result.put("success",false);
//                result.put("msg","请选择 SKU 小类");
//                return result;
//            }
            if (null == object.getSku().getSkuname() || object.getSku().getSkuname().equals("")) {
                result.put("success", false);
                result.put("msg", "请输入 SKU 标题");
                return result;
            }
//            if (null == object.getSku().getSkusize() || object.getSku().getSkusize().equals("")){
//                result.put("success",false);
//                result.put("msg","请输入 SKU 规格");
//                return result;
//            }
            if (null == object.getSku().getSupplierNo() || object.getSku().getSupplierNo().equals("")) {
                result.put("success", false);
                result.put("msg", "选择供应商");
                return result;
            }

            SysProductDomain sysProductDomain = sysProductService.save(object.getSku());
            result.put("sku", sysProductDomain);
            return result;

        }
        return result;
    }

    @PostMapping("/delete")
    public Map<String, Object> delete(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String skucode = request.getParameter("skucode");
        Integer del = sysProductService.deleteSku(skucode);
        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        return result;
    }

    /**
     * 编辑 sku 保存
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/resaveSku")
    public Map<String, Object> resaveSku(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = null;
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            SysProductDomain object = JsonUtilByFsJson.jsonToBean(s, SysProductDomain.class);
            SkuTypeDomain type = skuTypeService.getBySkuTypeNo(object.getSkuTypeNo());
            SupplierDomain supplier = supplierService.getSupplierByNo(object.getSupplierNo());
            object.setSkuTypeName(type.getSkuTypeName());
            object.setSupplierid(supplier.getSupplierid());
            object.setSuppliername(supplier.getName());
            Integer update = sysProductService.update(object);
            if (null != update && update == 1) {
                result = new HashMap<>();
                result.put("success", true);
                result.put("sku", object);
            }
        }
        return result;
    }
}
