package com.bailuntec.cost.api;

import com.bailuntec.cost.api.domain.BuyDomain;
import com.bailuntec.cost.api.response.CostResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.text.ParseException;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/3 10:39 上午
 */
@FeignClient(name = "bailuntec-cost-api", url = "http://api.fee.bailuntec.com/purchase/other/buy/api")
public interface BuyApi {

    /**
     * 获取资产负债表相关采购单
     *
     * @param startDateStr yyyy-MM-dd
     * @param endDateStr   yyyy-MM-dd
     * @return 资产负债表相关采购单
     * @throws ParseException ex
     */
    @GetMapping("/balanceSheetBuy")
    CostResult<List<BuyDomain>> balanceSheetBuyList(@RequestParam(name = "startDate") String startDateStr,
                                                    @RequestParam(name = "endDate") String endDateStr) throws ParseException;
}
