package com.blt.other.module.cost.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.cost.dto.request.TransferReviewReq;
import com.blt.other.module.cost.model.CostCurrentReviewer;

import java.util.List;

/**
 * <p>
 * 费用单当前审核人 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
public interface ICostCurrentReviewerService extends IService<CostCurrentReviewer> {


    /**
     * currentUserId 是否可以审核 costNo
     *
     * @param oaUserId 用户id
     * @param costNo   费用单号
     * @return canAudit
     */
    Boolean canAudit(Integer oaUserId, String costNo);


    /**
     * 更新费用单当前审核人
     *
     * @param costNo           costNo
     * @param costReviewerList costReviewerList
     */
    void updateByCostNoAndReviewer(String costNo, List<CostReviewer> costReviewerList);


    /**
     * 更新费用单当前审核人
     *
     * @param costNo   costNo
     * @param oaUserid oaUserid
     */
    void updateByCostNoAndOaUserId(String costNo, List<Integer> oaUserid);


    /**
     * 转审核
     *
     * @param req req
     */
    void transferReview(TransferReviewReq req);
}
