package com.blt.other.module.auth.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaCompanyMapper;
import com.blt.other.module.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaCompany;
import com.blt.other.module.auth.service.IOaCompanyService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaCompanyServiceImpl extends ServiceImpl<OaCompanyMapper, OaCompany> implements IOaCompanyService {

    @Resource
    CostReviewerMapper costReviewerMapper;


    @Override
    public List<OaCompany> oaCompanyList() {
        return this.list();
    }

    @Override
    public IPage<OaCompany> reviewerList(CompanyReviewerListReq req) {

        IPage<OaCompany> page = new Page<>(req.getPageNum(), req.getPageSize());

        page = baseMapper.reviewerList(page, req);

        if (ListUtil.isNotEmpty(page.getRecords())) {
            List<Integer> oaCompanyIds = page.getRecords().stream().map(OaCompany::getOaCompanyId).collect(Collectors.toList());

            //最终审核人
            List<CostReviewer> finalCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, oaCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer));

            Map<Integer, CostReviewer> finalReviewerMap = finalCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            page.getRecords().forEach(record -> record.setFinalReviewer(finalReviewerMap.get(record.getOaCompanyId())));

            //财务审核人
            List<CostReviewer> financialCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, oaCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer));

            Map<Integer, CostReviewer> financialReviewerMap = financialCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            page.getRecords().forEach(record -> {
                record.setFinalReviewer(financialReviewerMap.get(record.getOaCompanyId()));
            });
        }

        return page;
    }

    @Cacheable("companyDict")
    @Override
    public Map<String, OaCompany> companyDict() {
        return this.list().stream().collect(Collectors.toMap(OaCompany::getName, oaCompany -> oaCompany));
    }

}
