package com.blt.other.module.cost.vo;

import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Slf4j
public enum CostPlanEnumVo {
    companyName(new HashMap<String, String>() {
        {
            put("付款", "付款主体");
            put("收款", "收款主体");
            put("借支", "付款主体");
            put("借还", "收款主体");
        }
    }),
    bankCompany(new HashMap<String, String>() {
        {
            put("付款", "收款单位");
            put("收款", "付款单位");
            put("借支", "收款单位");
        }
    }),
    bankName(new HashMap<String, String>() {
        {
            put("付款", "收款银行");
            put("收款", "付款银行");
            put("借支", "收款银行");
        }
    }),
    bankCard(new HashMap<String, String>() {
        {
            put("付款", "收款账户");
            put("收款", "付款账户");
            put("借支", "收款账户");
        }
    }),
    bankCardUser(new HashMap<String, String>() {
        {
            put("付款", "持卡人");
            put("收款", "持卡人");
            put("借支", "持卡人");
        }
    }),
    costRemark(new HashMap<String, String>() {
        {
            put("付款", "备注");
            put("收款", "备注");
            put("借支", "备注");
            put("借还", "备注");
        }
    }),
    lendType(new HashMap<String, String>() {
        {
            put("借支", "借支类别");
            put("借还", "借支类别");
        }
    }),
    supCostNo(new HashMap<String, String>() {
        {
            put("借还", "关联借支单");
        }
    }),
    typeName(new HashMap<String, String>() {
        {
            put("付款", "费用类别");
            put("收款", "收入类别");
            put("借支", "费用类别");
            put("借还", "费用类别");
        }
    }),
    projectType(new HashMap<String, String>() {
        {
            put("收款", "项目");
        }
    }),
    payCounteract(new HashMap<String, String>() {
        {
            put("借还", "冲销金额");
        }
    }),
    payLendBalance(new HashMap<String, String>() {
        {
            put("借还", "归还金额");
        }
    }),
    customerNum(new HashMap<String, String>() {
        {
            put("收款", "客户编号");
        }
    }),
    dic(new HashMap<String, String>() {
        {
            put("付款", "币种");
            put("收款", "币种");
            put("借支", "币种");
        }
    }),
    payDic(new HashMap<String, String>() {
        {
            put("借还", "借还币种");
        }
    }),
    planAmount(new HashMap<String, String>() {
        {
            put("收款", "原币金额");
            put("借支", "原币金额");
        }
    }),
    amount(new HashMap<String, String>() {
        {
            put("付款", "原币金额");
        }
    }),
    costReason(new HashMap<String, String>() {
        {
            put("付款", "费用用途");
            put("收款", "收款理由");
            put("借支", "借支理由");
            put("借还", "借还理由");
        }
    }),
    filePath(new HashMap<String, String>() {
        {
            put("付款", "附件名");
            put("收款", "附件名");
            put("借支", "附件名");
            put("借还", "附件名");
        }
    });


    private Map<String, String> typeMap;

    private Class clazz;
    
    private String parseMethod;

    CostPlanEnumVo(Map<String, String> typeMap) {
        this.typeMap = typeMap;
    }

    public static CostPlanEnumVo match(String name, CostPlanEnumVo defaultItem){
        for (CostPlanEnumVo item: CostPlanEnumVo.values()) {
            if (item.name().equals(name)) {
                return item;
            }
        }
        return defaultItem;
    }

    public static String getCostPlanField(String type, String fieldName){
        try {
            for (CostPlanEnumVo item : CostPlanEnumVo.values()) {
                if(item.typeMap.get(type) == null){
                    continue;
                }
                if (item.typeMap.get(type).equals(fieldName)) {
                    return item.name();
                }
            }
        }catch (Exception ex){
            log.error(ex.toString());
        }
        return "";
    }
}
