package com.blt.other.module.cost.dao;

import com.blt.other.module.database.model.TypeRelationDomain;
import com.blt.other.module.database.model.CostTypeDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostTypeDao {

    /**
     * 通过 companyNo 获取费用类型
     * @param CompanyNo
     * @return
     */
    List<CostTypeDomain> selectByCompanyNo(String CompanyNo);

    /**
     * 通过 companyNo 和 typeName 获取费用类型，用于新增类型时判断是否已存在
     * @return
     */
    CostTypeDomain selectByCompanyNoAndTypeName(CostTypeDomain ctd);

    /**
     * 通过 typeNo 获取费用类型
     * @param costTypeNo
     * @return
     */
    CostTypeDomain selectByTypeNo(String costTypeNo);

    /**
     * 保存费用类型
     * @param ctd
     * @return
     */
    Integer insert(CostTypeDomain ctd);

    /**
     * 查询所有类型
     * @return
     */
    List<CostTypeDomain> selectAll();

    CostTypeDomain selectByCompanyNameAndTypeName(@Param("companyName")String companyName, @Param("typeName") String typeName);

    CostTypeDomain selectByCompanyNoAndTypeNameAndCostForm(CostTypeDomain costTypeDomain);

    TypeRelationDomain getTyeRelation(@Param("typeName") String typeName);

    Integer insertTypeRalation(@Param("typeName") String typeName);
}
