package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.request.ApplyMoneyDetail;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.api.bailuntec.cw.response.CwResult;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.JsonUtilByJackson;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.exception.RpcException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.TofinanceVo;
import com.blt.other.database.model.CostTofinanceDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
@Service
public class Lend1CostServiceImpl extends AbstractCostService implements CostService {


    @Override
    public void toFinancial(CostDomain cost) {

        PostApplyReq req = cost.buildPostApplyReq();
        // 审核回调地址(ApplyCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costUrlProperties.costApplyCallbackUrlPost);
        // 出纳回调地址(CashierCallbackUrl)不可为空；
        req.setCashierCallbackUrl(costUrlProperties.costCashierCallbackUrlPost);
        req.setApplyType("" + 1);

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        if (cost.getCostDetailDomainList() != null && cost.getCostDetailDomainList().size() > 0){
            for (CostDetailDomain costDetailDomain: cost.getCostDetailDomainList()) {
                ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
                applyMoneyDetail.setName("借支单付款");
                applyMoneyDetail.setTypeName(costDetailDomain.getTypeName());
                applyMoneyDetail.setCategoryName(costDetailDomain.getCategoryName());
                applyMoneyDetail.setUnitCode(costDetailDomain.getDic());
                applyMoneyDetail.setUnitName(costDetailDomain.getDic());
                applyMoneyDetail.setMoney(costDetailDomain.getAmount());
                BigDecimal toRmbRate = CurUtils.getCur(costDetailDomain.getDic(), "CNY");
                if (BigDecimal.ZERO.compareTo(toRmbRate) == 0) {
                    throw new BizRuntimeException("获取汇率异常,请重试!");
                }
                applyMoneyDetail.setMoneyRmb(costDetailDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
                applyMoneyDetail.setProject(costDetailDomain.getProject());
                applyMoneyDetail.setProjectDate(costDetailDomain.getProjectDate());
                applyMoneyDetail.setRemark("");
                applyMoneyDetailList.add(applyMoneyDetail);
            }
        } else {
            ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
            applyMoneyDetail.setName("借支单付款");
            applyMoneyDetail.setMoney(cost.getAmount());
            applyMoneyDetail.setMoneyRmb(cost.getAmount());
            applyMoneyDetail.setRemark("");
            applyMoneyDetailList.add(applyMoneyDetail);
        }
        // 出纳申请金额明细(MoneyDetail)不可为空；
        req.setMoneyDetail(applyMoneyDetailList);

        CwResult<String> cwResult = cwApi.postApply(req);
        if (!cwResult.getSuccess()) {
            throw new RpcException(cwResult.getMessage());
        }

        TofinanceVo tofinanceVo = JsonUtilByJackson.readValue(cwResult.getData().replaceAll("/^['|\"](.*)['|\"]$/", ""), TofinanceVo.class);

        //保存财务系统调用信息
        CostTofinanceDomain costTofinanceDomain = new CostTofinanceDomain();
        BeanUtils.copyProperties(tofinanceVo, costTofinanceDomain);
        costTofinanceDomain.setCostNo(cost.getCostNo().toUpperCase());
        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
        costTofinanceService.saveCostToFinanceMsg(costTofinanceDomain);
    }
}
