package com.blt.other.module.purchasing.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.module.database.model.BuyPlanDetailDomain;
import com.blt.other.module.database.model.BuyPlanDomain;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.service.BuyPlanDetailService;
import com.blt.other.module.purchasing.service.BuyPlanService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/plan/detail")
public class PurchasingPlanDetailController {

    @Autowired
    private BuyPlanDetailService buyPlanDetailService;
    @Autowired
    private BuyPlanService buyPlanService;

    @PostMapping("/deletePlanDetail")
    public Map<String,Object> deletePlanDetail(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = request.getParameter("no");
        String skucode = request.getParameter("skucode");
        buyPlanDetailService.delete(no,skucode);

        return updatePlan(no);
    }

    /**
     * 采购计划添加商品
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/addSkuToPlan")
    public Map<String,Object> addSkuToPlan(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = request.getParameter("no");
        String skucode = request.getParameter("skucode");
        //  判断是否已经存在该商品
        BuyPlanDetailDomain buyPlanDetailDomain = buyPlanDetailService.getByNoAndSkucode(no,skucode);
        if (null != buyPlanDetailDomain){
            Map<String,Object> map = new HashMap<>();
            map.put("success",false);
            map.put("msg","已存在该商品");
            return map;
        }
        String count = request.getParameter("count");
        BuyPlanDetailDomain detailDomain = new BuyPlanDetailDomain();
        detailDomain.setNo(no);
        detailDomain.setSkucode(skucode);
        detailDomain.setCount(Integer.parseInt(count));
        Integer save = buyPlanDetailService.save(detailDomain);

        return updatePlan(no);
    }

    /**
     * 改变商品采购数量
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/changeCount")
    public Map<String,Object> changeCount(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = request.getParameter("no");
        String count = request.getParameter("count");
        String skucode = request.getParameter("skucode");
        String price = request.getParameter("price");
        BuyPlanDetailDomain detail = new BuyPlanDetailDomain();
        detail.setNo(no);
        detail.setCount(Integer.parseInt(count));
        detail.setSkucode(skucode);
        detail.setAmount(new BigDecimal(price).multiply(new BigDecimal(Integer.parseInt(count))));
        Integer integer = buyPlanDetailService.update(detail);
        return updatePlan(no);
    }

    /**
     * 改变 plan_detail 信息时，同步改变采购计划信息
     * @param no
     * @return
     */
    private Map<String,Object> updatePlan(String no){
        List<BuyPlanDetailDomain> buyPlanDetailByno = buyPlanDetailService.getBuyPlanDetailByno(no);
        if (null != buyPlanDetailByno && buyPlanDetailByno.size() >= 1){
            BigDecimal planAmount = new BigDecimal(0);
            Integer count = 0;
            for (BuyPlanDetailDomain detail: buyPlanDetailByno){
                planAmount = planAmount.add(detail.getAmount());
                count += detail.getCount();
            }
            Map<String,Object> result = new HashMap<>();
            result.put("buyPlanDetails",buyPlanDetailByno);
            result.put("planAmount",planAmount);
            result.put("success",true);
            // 修改采购计划总金额、总数
            BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
            buyPlanDomain.setNo(no);
            buyPlanDomain.setAmount(planAmount);
            buyPlanDomain.setCount(count);
            Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
            return result;
        } else {
            Map<String,Object> result = new HashMap<>();
            result.put("planAmount",0);
            result.put("success",true);
            // 修改采购计划总金额、总数
            BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
            buyPlanDomain.setNo(no);
            buyPlanDomain.setAmount(new BigDecimal(0));
            buyPlanDomain.setCount(0);
            Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
            return result;
        }
    }

    /**
     * 修改采购计划
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/resetPlan")
    public Map<String,Object> resetPlan(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()){
            String s = parameterNames.nextElement();
            String[] split = s.split("buyPlan\":");
            String substring = split[1].substring(0, split[1].lastIndexOf("}"));
            BuyPlanDto object = (BuyPlanDto)MyMapperUtil.getObject(substring, BuyPlanDto.class);
            BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
            BeanUtils.copyProperties(object,buyPlanDomain);
            Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
        }
        return null;
    }

    /**
     * 废弃采购计划
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/abandonPlan")
    public Map<String,Object> abandonPlan(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String no = request.getParameter("no");
        Map<String,Object> map = new HashMap<>();
        BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
        buyPlanDomain.setNo(no);
        buyPlanDomain.setStatus(3);
        Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
        if (null != integer && integer == 1){
            map.put("success",true);
            map.put("msg","采购计划已废弃");
        } else {
            map.put("success",false);
            map.put("msg","操作失败，请稍后重试");
        }
        return  map;
    }

    /**
     * 主管审核驳回采购计划
     * @param response
     * @param request
     * @return
     */
//    @PostMapping("/rejectPlan")
//    public Map<String,Object> rejectPlan(HttpServletResponse response,HttpServletRequest request){
//        AxiosUtil.setCors(response,request);
//        BuyPlanDomain buyPlanDomain = new BuyPlanDomain();
//        buyPlanDomain.setNo(request.getParameter("no"));
//        buyPlanDomain.setAudituserid(Integer.parseInt(request.getParameter("audituserid")));
//        buyPlanDomain.setAuditusername(request.getParameter("auditusername"));
//        buyPlanDomain.setAudittime(new Date());
//        buyPlanDomain.setModifytime(new Date());
//        buyPlanDomain.setModifyuserid(Integer.parseInt(request.getParameter("audituserid")));
//        buyPlanDomain.setModifyusername(request.getParameter("auditusername"));
//        buyPlanDomain.setRejectReason(request.getParameter("rejectReason"));
//        buyPlanDomain.setStatus(4);
//        Integer integer = buyPlanService.updateBuyPlan(buyPlanDomain);
//        if (null != integer && integer >= 1){
//            Map<String,Object> map = new HashMap<>();
//            map.put("success",true);
//            map.put("msg","采购计划已驳回");
//            return map;
//        }
//        return null;
//    }

    /**
     * 确认采购计划
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/planAffirm")
    public Map<String,Object> planAffirm(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        BuyPlanDomain plan = new BuyPlanDomain();
        plan.setNo(request.getParameter("no"));
        plan.setAudituserid(Integer.parseInt(request.getParameter("audituserid")));
        plan.setAuditusername(request.getParameter("auditusername"));
        Integer buys = buyPlanService.auditPass(plan);
        Map<String,Object> result = new HashMap<>();
        if (null != buys && buys >= 1){
            result.put("success",true);
            result.put("msg","已生成 "+buys+" 张采购单，请在采购单列表查看");
        }else if (null != buys && buys == 0){
            result.put("success",true);
            result.put("msg","生成 0 张采购单");
        }else {
            result.put("success",false);
            result.put("msg","生成采购单失败，请联系管理员");
        }
        return result;
    }
}
