package com.blt.other.module.sys.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 部门审核人
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="DepartmentReviewer对象", description="部门审核人")
public class DepartmentReviewer implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "一级部门id")
    private Integer primaryDepartmentId;

    @ApiModelProperty(value = "一级部门")
    private String primaryDepartmentName;

    @ApiModelProperty(value = "二级部门id")
    private Integer secondDepartmentId;

    @ApiModelProperty(value = "二级部门")
    private String secondDepartmentName;

    @ApiModelProperty(value = "自动审核金额")
    private BigDecimal autoReviewAmount;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最近一次更新时间")
    private LocalDateTime lastUpdateTime;

    @ApiModelProperty(value = "更新人id")
    private Integer updateUserId;

    @ApiModelProperty(value = "更新人")
    private String updateUserName;


}
