package com.blt.other.module.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.service.CostDetailService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class CostDetailServiceImpl implements CostDetailService {

    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    CostDao costDao;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {
        return costDetailDao.selectListByCostNo(costNo);
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }

    @Override
    public void deleteFilePath(String detailNo) {
        costDetailDao.deletedFilePath(detailNo);
    }


    @Transactional
    @Override
    public Integer update(CostDetailDomain domain) {
        //更新费用单
        return costDetailDao.update(domain, new LambdaQueryWrapper<CostDetailDomain>()
                .eq(CostDetailDomain::getDetailNo, domain.getDetailNo()));
    }
}
