package com.blt.other.common.interceptor;

import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

/**
 * <p>
 * spring mvc拦截器配置
 * </p>
 *
 * @author robbendev
 */
@Configuration
@AllArgsConstructor
public class MvcInterceptorConfig extends WebMvcConfigurationSupport {

    private final SessionHandlerInterceptor sessionHandlerInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {


        registry.addInterceptor(sessionHandlerInterceptor)
                .excludePathPatterns();


        super.addInterceptors(registry);
    }


    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {

        //swagger增加url映射
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");

        registry.addResourceHandler("/doc.html")
                .addResourceLocations("classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }


}


