package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.dao.CostLogDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description： 增加工厂流程审核，目前限定赵鹏审核，1w（含）以上全部审核，3k(含)-1w（不含）每周随机最多3单，可能只是暂时性，所以先hard code,后续有需求再改
 * @Date: Created in
 * @Modified by:
 */
@Component
@Scope("prototype")
public class FactoryCheckState extends CostState {

    //@Resource
    //UnPayState unPayState;
    @Resource
    FinalCheckState finalCheckState;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    ApprovalHistoryService approvalHistoryService;
    @Resource
    CostTypeDao costTypeDao;
    @Resource
    CostLogDao costLogDao;

    //审批次数  周 -> 次数
    static Map<Integer, Integer> APPROVE_TIMES = new ConcurrentHashMap<>();

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        //CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FACTORY_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }
        //自动审核流转
        if (this.autoPass(costDomain)) {
            costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);

            List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
            costLogService.saveByManage(costDomain.getCostNo(), "工厂自动审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                    .collect(Collectors.joining(",")), CostLogDomain.FACTORY_AUTO_PASS);
            //流转状态
            nextState(finalCheckState);
            //发布到总线尝试下个环节的自动审核
            costSubscribe.subscribe(costContext);

            //通知财务系统
            //costContext.costService.toFinancial(costDomain);
            return;

        }
        if (currentUserId != null) {
            //目前限定赵鹏能审核
            if (currentUserId == 720 || currentUserId == 3075) {
                //大于等于3k需要赵鹏审批
                if (costDomain.getAmountRmb().compareTo(new BigDecimal("3000")) >= 0) {
                    costDomain.setCostStatus(CostDomain.STATUS_FINAL_CHECK);
                    costDomain.setLastModifyDate(LocalDateTime.now());
                    costDao.updateById(costDomain);

                    List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
                    costLogService.save(costDomain.getCostNo(), currentUserId, "工厂审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                            .collect(Collectors.joining(",")), CostLogDomain.FACTORY_MANUAL_PASS);
                    //流转状态
                    nextState(finalCheckState);
                    //发布到总线尝试下个环节的自动审核
                    costSubscribe.subscribe(costContext);
                    return;
                }
            } else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        //CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FACTORY_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核拒绝
        if (currentUserId == 720 || currentUserId == 3075) {
            ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                    .approvalUserId(currentUserId)
                    .approvalTime(LocalDateTime.now())
                    .costStatus(costDomain.getCostStatus())
                    .costNo(costDomain.getCostNo())
                    .isPassed(false)
                    .build();
            approvalHistoryService.save(approvalHistoryDomain);
            costContext.costService.reject(costDomain.getCostNo());
            costLogService.save(costDomain.getCostNo(), currentUserId, "工厂审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);
        } else {
            throw new BizRuntimeException("current user no authority");
        }
    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;

        //只查赵鹏的ID
        OaUser user = oaUserMapper.selectByOaUserId(720);

        List<CostReviewer> costReviewerList = new ArrayList<>();
        costReviewerList.add(CostReviewer.builder()
                .reviewerUserId(user.getOaUserId())
                .reviewerUserName(user.getUserName())
                .build());
        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
//        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "最终审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));

    }

    private boolean autoPass(CostDomain costDomain) {
        if(costContext.currentUserId != null)
            return false;
        CostLogDomain costLogDomain = costLogDao.selectDepartmentCheckLog(costDomain.getCostNo());
        List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
        if (costLogDomain != null
                && costCurrentReviewerList
                .stream()
                .map(CostCurrentReviewer::getOaUserId)
                .collect(Collectors.toList())
                .contains(costLogDomain.getUpdateUserid())) {
            //部门审核人和工厂审核人是同一个人，工厂审核人自动通过。
            return true;
        }
        //小于3k不需要审核
        if(costDomain.getAmountRmb().compareTo(BigDecimal.valueOf(3000)) < 0) {
            return true;
        }

        //3k-1w需要随机审核，每周三单；
        if (costDomain.getAmountRmb().compareTo(BigDecimal.valueOf(3000)) >= 0 && costDomain.getAmountRmb().compareTo(BigDecimal.valueOf(10000)) < 0) {
            LocalDate nowDay = LocalDate.now();
            WeekFields weekFields = WeekFields.ISO;
            Integer weekCounter = nowDay.get(weekFields.weekOfWeekBasedYear());
            Integer times = APPROVE_TIMES.get(weekCounter);
            if (times == null) {
                APPROVE_TIMES = new ConcurrentHashMap<>();
                times = 0;
            }
            if (times < 3 && LocalDateTime.now().getSecond() % 3 == 0) {
                APPROVE_TIMES.put(weekCounter, ++times);
            } else if(times.equals(0) && APPROVE_TIMES.isEmpty() && nowDay.getDayOfWeek().equals(DayOfWeek.WEDNESDAY)){
                //周四还没随机到先搞一单进去
                APPROVE_TIMES.put(weekCounter, 1);
            }
            else
                return false;
            return true;
        }

        return false;
    }
}
