package com.blt.other.module.purchasing.service;

import com.blt.other.database.model.PlanSkuTempDomain;

import java.util.List;

public interface PlanSkuTempService {

    /**
     * 缓存商品到采购计划单
     * @param no
     * @param skucode
     * @param skucount
     * @return
     */
    Integer saveToPlanSkuTemp(String no,String skucode,Integer skucount);

    /**
     * 通过 no 获取缓存表中的商品
     * @param no
     * @return
     */
    List<PlanSkuTempDomain> getAllByNo(String no);

    /**
     * 修改缓存表商品信息
     */
    Integer resetSkuTemp(PlanSkuTempDomain planSkuTempDomain);

    PlanSkuTempDomain getTmpByNoAndSkucode(String no, String skucode);

    void delete(String no, String skucode);
}
