package com.blt.other.module.cost.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 费用单模版
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostTemplate对象", description = "费用单模版")
public class CostTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("1-付款单2-收款单 3-借支单 4-借还单")
    private Integer costType;

    @ApiModelProperty(value = "费用单模版名")
    private String templateName;

    @ApiModelProperty("是否开启自动审核")
    private Boolean enableAutoReview;

    @ApiModelProperty("是否开启部门审核")
    private Boolean enableDepartmentReview;

    @ApiModelProperty("是否开启财务自动审核")
    private Boolean enableFinancialAutoReview;

    @ApiModelProperty("是否开启最终人审核")
    private Boolean enableFinalReview;

    @ApiModelProperty("自动审核金额 冗余从表金额字段")
    private BigDecimal autoCheckAmount;

    //    @TableField(exist = false)
    @ApiModelProperty("是否设置了自动审核规则")
    private Boolean setAutoCheck;

    @ApiModelProperty("最终审核人最低审核金额")
    private BigDecimal finalMinimumReviewAmount;

    @ApiModelProperty("是否默认模版")
    private Boolean isDefault;

    private Integer createUserId;

    private String createUserName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间")
    private LocalDateTime lastUpdateTime;

    private Integer updateUserId;

    private String updateUserName;

    @TableField(exist = false)
    private List<CostTemplateCol> costTemplateColList;


    public boolean shouldDepartmentAutoCheck(CostDomain cost) {
        return enableAutoReview && enableDepartmentReview && !isDefault
//                && !cost.getCompanyName().contains("工会")
                ;
    }

    public boolean shouldFinancialAutoCheck(CostDomain cost) {
        return enableAutoReview && enableFinancialAutoReview && !isDefault
//                &&   !cost.getCompanyName().contains("工会")
                ;
    }

    public boolean shouldFinalAutoCheck(CostDomain cost) {
        return enableAutoReview && enableFinalReview && !isDefault
//                &&  !cost.getCompanyName().contains("工会")
                ;
    }

    public boolean shouldFinalCheck(CostDomain cost) {
        BigDecimal amount = cost.getAmountRmb();

        return !(finalMinimumReviewAmount.compareTo(BigDecimal.ZERO) > 0 &&
                amount.compareTo(finalMinimumReviewAmount) < 0
//                && !cost.getCompanyName().contains("工会")
        )
                ;
    }

    public boolean shouldDepartmentCheck(CostDomain cost, BigDecimal departmentMinimumReviewAmount) {
        BigDecimal amount = cost.getAmountRmb();

        return !(departmentMinimumReviewAmount.compareTo(BigDecimal.ZERO) > 0 &&
                amount.compareTo(departmentMinimumReviewAmount) < 0
//                && !cost.getCompanyName().contains("工会")
        );
    }

    public boolean shouldHrCheck(CostDomain costDomain) {
        return costDomain.getCompanyName().contains("工会");
    }
}
