package com.blt.other.common.rabbitmq.service.receiver;

import com.blt.other.common.rabbitmq.model.HandleResult;
import com.blt.other.common.rabbitmq.model.MessageData;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@Slf4j
public abstract class AbstractReceiver implements Receiver{
    /**
     * 用户自定义消息处理
     *
     * @param messageData
     * @return
     */
    public abstract HandleResult exec(MessageData messageData) throws Exception;

    /**
     * 成功处理
     *
     * @param messageData
     * @return
     */
    public abstract HandleResult handleSuccess(MessageData messageData);

    /**
     * 失败处理
     *
     * @param messageData
     * @return
     */
    public abstract HandleResult handleFail(MessageData messageData);

    /**
     * 处理
     *
     * @param messageData
     * @return
     */
    @Override
    public final HandleResult handleMessage(MessageData messageData) {
        log.info(this.getClass().getSimpleName() + "-->handleMessage()参数 unicomData:{}", messageData.toString());
        HandleResult handleResult = null;
        try {
            // 根据自行处理的返回结果
            handleResult = this.exec(messageData);

            // 执行成功处理的逻辑
            handleResult = this.handleSuccess(messageData);
        } catch (Exception e) {
            e.printStackTrace();
            messageData.setContent(e.getMessage());
            return this.handleFail(messageData);
        }
        return handleResult;
    }
}
