package com.blt.other.module.cost.service.impl.costtemplate;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.cost.dao.CostTemplateBaseColMapper;
import com.blt.other.module.cost.dto.CostTemplateBaseColApiReq;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 费用单基础字段 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateBaseColServiceImpl extends ServiceImpl<CostTemplateBaseColMapper, CostTemplateBaseCol> implements ICostTemplateBaseColService {

    @Override
    public List<CostTemplateBaseCol> listAll() {
        return this.list();
    }

    @Override
    public CostTemplateBaseCol add(CostTemplateBaseColApiReq.AddReq req) {
        if (!req.getIsExtension()) {
            throw new RuntimeException("只能添加扩展字段");
        }
        CostTemplateBaseCol costTemplateBaseCol = new CostTemplateBaseCol();
        BeanUtils.copyProperties(req, costTemplateBaseCol);
        this.save(costTemplateBaseCol);
        return costTemplateBaseCol;
    }

    @Override
    public void modify(CostTemplateBaseCol costTemplateBaseCol) {
        this.updateById(costTemplateBaseCol);
    }

    @Override
    public void delete(@NonNull Integer id) {
        this.removeById(id);
    }

    @Override
    public List<CostTemplateBaseCol> defaultBaseColList(@NonNull Integer costFrom) {
        return baseMapper.defaultBaseColList(costFrom);
    }

    @Override
    public void setCostTemplateBaseCol(List<CostTemplateCol> costTemplateColList) {

        List<Integer> costTemplateBaseColIds = costTemplateColList.stream().map(CostTemplateCol::getCostTemplateBaseColId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(costTemplateBaseColIds)) {
            List<CostTemplateBaseCol> costTemplateBaseColList = this.listByIds(costTemplateBaseColIds);
            Map<Integer, CostTemplateBaseCol> costTemplateBaseColMap = costTemplateBaseColList.stream().collect(Collectors.toMap(CostTemplateBaseCol::getId, costTemplateBaseCol -> costTemplateBaseCol, (k1, k2) -> k1));

            costTemplateColList.forEach(costTemplateCol -> costTemplateCol.setCostTemplateBaseCol(costTemplateBaseColMap.get(costTemplateCol.getCostTemplateBaseColId())));
        }
    }
}
