package com.blt.other.common.job;

import org.quartz.*;
import org.springframework.context.annotation.Bean;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 17:12 2021-04-24
 * @Modified by:
 */
public class NetSuiteSyncJobConfiguration {
    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail netSuiteSyncJobDetail(){
        return JobBuilder.newJob(NetSuiteSyncJob.class)
                .withIdentity("netSuiteSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger netSuiteSyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(netSuiteSyncJobDetail())
                .withIdentity("netSuiteSyncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
