package com.blt.other.module.cost.service.impl;

import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.bailuntec.cost.api.dto.CostTypeDto;
import com.blt.other.module.database.model.TypeRelationDomain;
import com.blt.other.module.cost.service.CostTypeService;
import com.blt.other.module.database.mapper.StatusMapper;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostTypeDomain;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class CostTypeServiceImpl implements CostTypeService {

    @Autowired
    private CostTypeDao costTypeDao;
    @Autowired
    private CostCompanyDao costCompanyDao;

    @Autowired
    private StatusMapper statusMapper;

    @Override
    public List<CostTypeDto> getListByCompanyNo(String companyNo) {
        List<CostTypeDomain> costTypeDomains = costTypeDao.selectByCompanyNo(companyNo);
        List<CostTypeDto> dtos = null;
        if (null != costTypeDomains && costTypeDomains.size() >=1){
            dtos =  new ArrayList<>();
            for (CostTypeDomain costTypeDomain: costTypeDomains){
                CostTypeDto costTypeDto = domainToDto(costTypeDomain);
                if (null != costTypeDto) {
                    dtos.add(costTypeDto);
                }
            }
        }

        return dtos;
    }

    /**
     * 保存费用类型
     * @return
     */
    @Override
    public Integer saveNewType(CostTypeDomain costTypeDomain) {
        // 判断是否已经存在相同 companyNo ，相同 typeName
        CostTypeDomain byCompanyNoAndTypeName = costTypeDao.selectByCompanyNoAndTypeName(costTypeDomain);
        if (null != byCompanyNoAndTypeName && null != byCompanyNoAndTypeName.getTypeNo()){
            return null;
        }
        // 执行 doInsert()
        Integer integer = doInsert(costTypeDomain);
        return integer;
    }

    /**
     * 获取所有类型
     * @return
     */
    @Override
    public List<CostTypeDomain> getAllType() {
        List<CostTypeDomain> list = costTypeDao.selectAll();

        return list;
    }

    @Override
    public CostTypeDto domainToDto(CostTypeDomain costTypeDomain) {
        CostTypeDto costTypeDto = null;
        if (null != costTypeDomain && null != costTypeDomain.getTypeNo()){
            costTypeDto = new CostTypeDto();
            BeanUtils.copyProperties(costTypeDomain,costTypeDto);
            return costTypeDto;
        }
        return costTypeDto;
    }

    @Override
    public CostTypeDomain getByTypeNo(String typeNo) {
        return costTypeDao.selectByTypeNo(typeNo);
    }

    @Override
    public TypeRelationDomain getTyeRelation(String typeName) {
        return costTypeDao.getTyeRelation(typeName);
    }

    @Override
    public Integer insertTypeRalation(String typeName) {
        return costTypeDao.insertTypeRalation(typeName);
    }

    public Integer doInsert(CostTypeDomain ctd){
        // 获取 companyName
        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(ctd.getCompanyNo());
        ctd.setCompanyName(companyDomain.getCompanyName());
        ctd.setTypeNo(createTypeNo());
        // 执行 insert
        Integer integer = costTypeDao.insert(ctd);
        return integer;
    }
    /**
     * 生成唯一的费用类型编号
     * @return
     */
    private String createTypeNo(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Random random = new Random();
        String costTypeNo = "CTN"+sdf.format(new Date())+random.nextInt(9);
        CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(costTypeNo);
        while (null != costTypeDomain && null != costTypeDomain.getTypeName()){
            costTypeNo = "CTN"+sdf.format(new Date())+random.nextInt(9);
            costTypeDomain = costTypeDao.selectByTypeNo(costTypeNo);
        }
        return costTypeNo;
    }
}
