package com.blt.other.other_auth.service.impl;

import com.blt.other.other_auth.service.GetDeparmentListService;
import com.blt.other.other_auth.vo.DeparmentMsg;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

@Service
public class GetDeparmentListServiceImpl implements GetDeparmentListService {

    Logger logger = LoggerFactory.getLogger(GetDeparmentListServiceImpl.class);

    @Autowired
    private RestTemplate restTemplate;

    @Value("${url.api.GetDeparmentListApi}")
    private String getDeparmentListApi;

    @Override
    public List<DeparmentMsg> getList() {
        ResponseEntity<String> forEntity = restTemplate.getForEntity(getDeparmentListApi,String.class);
        if(forEntity.getStatusCodeValue() == 200){
            String strBody = forEntity.getBody();
            ObjectMapper mapper = new ObjectMapper();
            JavaType javaType = mapper.getTypeFactory().constructParametricType(Collection.class,DeparmentMsg.class);
            try {
                List<DeparmentMsg> list = (List<DeparmentMsg>)mapper.readValue(strBody,javaType);
                return list;
            } catch (IOException e) {
                logger.error("GetDeparmentListServiceImpl",e);
            }
        }
        return null;
    }

    @Override
    public DeparmentMsg getDeparment(String deparmentName) {
        List<DeparmentMsg> list = getList();
        if (null != list && list.size() >= 1){
            for (DeparmentMsg deparmentMsg: list){
                if (null != deparmentName && (deparmentName.toLowerCase()).equals((deparmentMsg.getName()).toLowerCase())){
                    return deparmentMsg;
                }
            }
        }
        return null;
    }


}
