package com.blt.other.module.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.DepartmentReviewer;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 部门审核人 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
public interface DepartmentReviewerMapper extends BaseMapper<DepartmentReviewer> {

    //获取部门审核人配置列表
    IPage<DepartmentReviewerListItem> departmentReviewerList(@Param("page") IPage<DepartmentReviewerListItem> page,
                                                             @Param("req") DepartmentReviewerListReq req);

    //获取一级部门配置
    //todo
    DepartmentReviewer selectByPrimaryDepartmentId(Integer primaryDepartmentId);

    //获取二级部门配置
    DepartmentReviewer selectBySecondDepartmentId(Integer secondDepartmentId);
}
