package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.UserCostFinansysService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_cost.utils.CostPlanUtils;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_database.model.UserCostFinansysDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan/new/receipt")
public class CostPlanNewReceiptController {

    @Autowired
    private CostPlanService costPlanService;
    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @PostMapping("/saveFile")
    public Map<String,Object> saveFile(HttpServletResponse response, HttpServletRequest request,@RequestParam("fileSelect") MultipartFile file){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String planNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlanDomain = costPlanService.getByPlanNo(planNo);
        if (null != costPlanDomain){
            result.put("success",false);
            return result;
        }
        CostPlanDomain costPlan = CostPlanUtils.createCostPlan(request, planNo);

        // 文件上传的路径
        String filePath = PathUtil.getBasePath()+PathUtil.getPath("cost/"+costPlan.getCostPlanNo()+"/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        costPlan.setFilePath(path);
        // 保存财务信息
        Integer finansyRecord = doSaveFinansyRecord(costPlan);
        Integer integer = costPlanService.save(costPlan);
        if (null != integer && integer >= 1){
            result.put("msg","费用单已创建");
            result.put("plan",costPlan);
            result.put("success",true);
            return result;
        }
        result.put("msg","费用单创建失败");
        return result;
    }

    @PostMapping("/saveNoFile")
    public Map<String,Object> saveNoFile(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String planNo = request.getParameter("costPlanNo");
        CostPlanDomain costPlanDomain = costPlanService.getByPlanNo(planNo);
        if (null != costPlanDomain){
            result.put("success",false);
            return result;
        }
        CostPlanDomain costPlan = CostPlanUtils.createCostPlan(request, planNo);
        // 保存财务信息
        Integer finansyRecord = doSaveFinansyRecord(costPlan);
        Integer integer = costPlanService.save(costPlan);
        if (null != integer && integer >= 1){
            result.put("success",true);
            result.put("msg","收款计划已创建");
            result.put("plan",costPlan);
            return result;
        }
        result.put("msg","收款计划创建失败");
        return result;
    }

    /**
     * 保存填写的财务信息
     * @return
     */
    private Integer doSaveFinansyRecord(CostPlanDomain planDomain){
        UserCostFinansysDomain finansyRecordByCostDomain = userCostFinansysService.createFinansyRecordByCostPlanDomain(planDomain);
        Integer integer = userCostFinansysService.saveFinansysRecord(finansyRecordByCostDomain);
        return integer;
    }
}
