package com.blt.other.module.log.service.impl;

import com.blt.other.module.log.dao.OperationLogDao;
import com.blt.other.module.log.dto.SearchInput;
import com.blt.other.module.log.model.OperationLog;
import com.blt.other.module.log.service.OperationLogService;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.domain.*;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Service
@Transactional
public class OperationLogServiceImpl implements OperationLogService {

    @Resource
    private OperationLogDao operationLogDao;

    @Resource
    private MongoTemplate mongoTemplate;

    @Override
    @Async
    public void insert(OperationLog log) {
        log.setCreateTime(LocalDateTime.now());
        operationLogDao.insert(log);
    }

    @Override
    public List<OperationLog> select(SearchInput input) {
        List<OperationLog> list = new ArrayList<>();
        Query query = new Query();
        /*query.addCriteria(Criteria.where("createTime").in(input.getCreateTime(),input.getCreateTime().plusDays(1)));
        if(input.getSourceFrom() != null && !input.getSourceFrom().isEmpty()){
            query.addCriteria(Criteria.where("sourceFrom").is(input.getSourceFrom()));
        }
        StringBuffer query = new StringBuffer("{}");*/
        Document document = new Document();
        document.put("createTime",String.format("{$lt :%s, $gt : %s}",input.getCreateTime(),input.getCreateTime().plusDays(1)));

        /*mongoTemplate.getCollection("OperationLog")
                .find(document)
                .skip((input.getPageNum() - 1) * input.getPageSize())
                .limit(input.getPageSize())
                ;
        mongoTemplate.fi
        mongoTemplate.find(x -> x.)*/
        return null;
    }
}
