package com.blt.other.module.cost.service.impl;

import com.bailuntec.cost.api.dto.*;
import com.bailuntec.cost.api.request.ManageCostListReq;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.config.property.ProjectConstant;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.common.util.PathUtil;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.database.model.UserDomain;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostApiService;
import com.blt.other.module.cost.service.UserCostFinansysService;
import com.blt.other.module.cost.service.impl.costcheck.CostContext;
import com.blt.other.module.cost.service.impl.costcheck.FinancialCheckState;
import com.blt.other.module.cost.utils.CostFileUtil;
import com.blt.other.module.cost.utils.CostUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CostApiServiceImpl implements CostApiService {
    private static Logger logger = LoggerFactory.getLogger(CostApiServiceImpl.class);

    @Resource
    private CostDao costDao;
    @Resource
    private UserDao userDao;
    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    private UserCostFinansysService userCostFinansysService;
    @Resource
    CostLogDao costLogDao;
    @Resource
    CostCompanyDao costCompanyDao;

    @Override
    @Transactional
    public String generateLogisticsCost(int costForm, LogisticsCostDto logisticsCostDto) throws Exception {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum();
        costDomain.setCostNo(costNo);
        costDomain.setCostForm(costForm); // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostStatus(0); //  0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostRemark(logisticsCostDto.getCostRemark() + "【WMS系统推送】");
        costDomain.setCostReason(logisticsCostDto.getCostReason());
        costDomain.setTypeNo("CTN1809180519188");
        costDomain.setTypeName("销售费用/物流费");
//        costDomain.setKindNo("CTK1809181719182");
//        costDomain.setKindName("物流费");
//        costDomain.setSubjectCode("660104");
        costDomain.setCompanyName("香港百伦科技有限公司");
        costDomain.setCompanyNo("COM1806191800013");
        costDomain.setAmount(logisticsCostDto.getAmount());
        costDomain.setDic(logisticsCostDto.getCurrency());
        costDomain.setSourceFrom(logisticsCostDto.getSourceFrom());
        BigDecimal toRmbRate;
        if ("CNY".equals(logisticsCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(logisticsCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(logisticsCostDto.getCurrency(), "CNY");
            costDomain.setAmountRmb(logisticsCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);

        List<LogisticsFinansysDto> logisticsList = userCostFinansysService.getAllLogisticsFinance(); // 一级物流供应商
        List<SubLogisticsFinansysDto> subLogisticsList = userCostFinansysService.getAllSubLogisticsFinance(); // 二级物流供应商
        if (logisticsList != null && subLogisticsList != null) {
            if (logisticsCostDto.getSubLogisticsSupplierId() == 0) {
                // 没有二级，只有一级
                for (LogisticsFinansysDto logistics : logisticsList) {
                    if (logistics.getId().intValue() == logisticsCostDto.getLogisticsSupplierId().intValue()) {
                        costDomain.setLogisticsSupplierId(logistics.getId());
                        costDomain.setBankCompany(logistics.getName());
                        costDomain.setBankCardUser(logistics.getBankuser());
                        costDomain.setBankCard(logistics.getBankcard());
                        costDomain.setBankName(logistics.getBankname());
                        break;
                    }
                }
            } else {
                // 根据二级找一级
                for (SubLogisticsFinansysDto subLogistics : subLogisticsList) {
                    if (subLogistics.getId().intValue() == logisticsCostDto.getSubLogisticsSupplierId().intValue()) {
                        costDomain.setSubLogisticsSupplierId(subLogistics.getId());
                        for (LogisticsFinansysDto logistics : logisticsList) {
                            if (logistics.getId().intValue() == subLogistics.getParentid().intValue()) {
                                costDomain.setLogisticsSupplierId(logistics.getId());
                                costDomain.setBankCompany(logistics.getName());
                                costDomain.setBankCardUser(logistics.getBankuser());
                                costDomain.setBankCard(logistics.getBankcard());
                                costDomain.setBankName(logistics.getBankname());
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        } else {
            throw new Exception("获取一二级物流供应商信息失败！");
        }
        logisticsList.clear();
        subLogisticsList.clear();

        if (costDomain.getLogisticsSupplierId() == null) {
            throw new Exception("没有匹配到一级物流供应商信息！");
        }

        UserDomain user = userDao.selectByuserid(logisticsCostDto.getUserId());
        if (user == null) {
            throw new Exception("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateTime(new Date());
        }
        costDomain.setCostTemplateIdByFrom();
        costDao.insert(costDomain);
        if (costForm == 1) {
            CostDetailDomain costDetailDomain = new CostDetailDomain();
            BeanUtils.copyProperties(costDomain, costDetailDomain);
            costDetailDomain.setDetailNo(costNo + "-1");
            costDetailDao.insert(costDetailDomain);
        }
        return costNo;
    }

    @Override
    public List<CostDomain> getNoPayCost(List<String> costNoList) {
        return costDao.selectList(new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostForm, CostDomain.COST_FROM_1)
                .eq(CostDomain::getCostStatus, CostDomain.STATUS_PAYED)
                .in(CostDomain::getCostNo, costNoList));
    }

    @Override
    public CostDomain getCostDetails(String costNo) {
        return costDao.selectByCostNo(costNo);
    }

    @Resource
    CostTypeDao costTypeDao;
    @Resource
    AccountingSubjectMapper accountingSubjectMapper;
    @Resource
    FinancialCheckState financialCheckState;

    @Override
    public String pushWageCost(WageCostDto wageCostDto) throws IOException {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum();
        costDomain.setCostNo(costNo);
        // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostForm(CostDomain.COST_FROM_1);
        // 0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);

        //类型信息
        CostTypeDomain costTypeDomain = costTypeDao.selectByNameAndType("工资", CostTypeDomain.feeType);
        AccountingSubject accountingSubject = accountingSubjectMapper.selectByNo(costTypeDomain.getAccountingSubjectNo());
        costDomain.setTypeNo(costTypeDomain.getTypeName());
        costDomain.setTypeName(costTypeDomain.getTypeName());
        costDomain.setAccountingSubjectNo(accountingSubject.getSubjectNo());
        costDomain.setAccountingSubjectName(accountingSubject.getName());

        //公司
        CostCompanyDomain costCompany = costCompanyDao.selectByName(wageCostDto.getCompanyName());
        costDomain.setCompanyNo(costCompany.getCompanyNo());

        //财务主体信息
        costDomain.setCompanyName(wageCostDto.getCompanyName());
        costDomain.setCompanyValue(wageCostDto.getCompanyValue());

        //银行卡四要素
        costDomain.setBankCard(wageCostDto.getBankCard());
        costDomain.setBankCardUser(wageCostDto.getBankCardUser());
        costDomain.setBankCompany(wageCostDto.getBankCompany());
        costDomain.setBankName(wageCostDto.getBankName());

        //金额信息
        costDomain.setAmount(wageCostDto.getAmount());
        costDomain.setDic(wageCostDto.getCurrency());

        //费用单来源
        costDomain.setSourceFrom(wageCostDto.getSourceFrom());

        costDomain.setCostRemark(wageCostDto.getCostRemark());
        costDomain.setCostReason(wageCostDto.getCostReason());

        BigDecimal toRmbRate;

        //todo simplify
        if (ProjectConstant.CNY.equals(wageCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(wageCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(wageCostDto.getCurrency(), ProjectConstant.CNY);
            costDomain.setAmountRmb(wageCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);

        UserDomain user = userDao.selectByuserid(wageCostDto.getUserId());
        if (user == null) {
            throw new BizRuntimeException("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateTime(new Date());
        }
        costDomain.setCostTemplateIdByFrom();
        //写入费用单
        costDao.insert(costDomain);

        //写入费用单详情
        CostDetailDomain costDetailDomain = new CostDetailDomain();

        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(wageCostDto.getFileUrl(), filePath);

        BeanUtils.copyProperties(costDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costNo + "-1");
        costDetailDomain.setFilePath(path);
        costDetailDao.insert(costDetailDomain);

        CostLogDomain costLogDomain = new CostLogDomain();
        costLogDomain.setCostNo(costNo);
        costLogDomain.setUpdateUserid(user.getUserid());
        costLogDomain.setUpdateUsername(user.getUsername());
        costLogDomain.setUpdateTime(new Date());
        costLogDomain.setUpdateNote("老板已经审批通过了");
        costLogDomain.setUpdateUsercode(user.getUsercode());
        costLogDao.insert(costLogDomain);


        CostContext costContext = new CostContext(costNo, costDomain.getCreateUserid());
        costContext.setCostState(financialCheckState);
        financialCheckState.updateCurrentReviewer();

        return costNo;
    }

    @Override
    public List<CostDto> getCostList(String startDate, String endDate, Integer pageNum, Integer pageSize) {
        IPage<CostDomain> page = new Page<>(pageNum, pageSize);

        return this.costDao.selectPage(page, new LambdaQueryWrapper<CostDomain>()
                .ge(CostDomain::getLastModifyDate, startDate)
                .le(CostDomain::getLastModifyDate, endDate))
                .getRecords()
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
    }

    @Override
    public List<ManageCostDto> manageCostList(ManageCostListReq req) {
        return null;
    }
}
