package com.bailuntec.cost.api.response;

import lombok.Data;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/9 1:07 下午
 */
@Data
public class CostResult<T> {
    private String message;
    private Boolean success;
    private T data;


    public static <T> CostResult<T> success(String message, T data) {
        CostResult<T> result = new CostResult<>();
        result.setSuccess(true);
        result.setMessage(message);
        result.setData(data);
        return result;
    }

    public static <T> CostResult<T> success(T data) {
        return success("", data);
    }

    public static <T> CostResult<T> success() {
        return successMsg("success");
    }


    public static <T> CostResult<T> successMsg(String message) {
        return success(message, null);
    }


    public static <T> CostResult<T> error(String message) {
        CostResult<T> result = new CostResult<>();
        result.setSuccess(false);
        result.setMessage(message);
        return result;
    }

    public static <T> CostResult<T> error() {
        CostResult<T> result = new CostResult<>();
        result.setSuccess(false);
        return result;
    }
}
