package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.AppCheckCostListReq;
import com.blt.other.module.cost.dto.request.AppCostListReq;
import com.blt.other.module.cost.dto.request.AppCostPassReq;
import com.blt.other.module.cost.dto.request.AppCostRejectReq;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/14 1:22 下午
 */
public interface AppCostService {

    /**
     * 小程序获取待审核费用列表
     *
     * @param req req
     * @return 待审核费用列表
     */
    Page<CostDto> appCheckCostList(AppCheckCostListReq req);

    /**
     * 小程序审核通过
     *
     * @param req req
     */
    void appCostPass(AppCostPassReq req);

    /**
     * 小程序审核拒绝
     *
     * @param req req
     */
    void appCostReject(AppCostRejectReq req);

    /**
     * 费用列表
     *
     * @param req req
     * @return 费用列表
     */
    Page<CostDto> appCostList(AppCostListReq req);
}
