package com.blt.other.database.model;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostAttach;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blt.other.database.mapper.StatusMapper;
import com.blt.other.module.cost.model.CostTemplate;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@TableName(value = "cost_plan", autoResultMap = true)
@Data
public class CostPlanDomain implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("费用计划编号")
    private String costPlanNo;
    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax;

    @ApiModelProperty("公司主体value")
    private Integer companyValue;
    @ApiModelProperty("主体编号")
    private String companyNo;
    @ApiModelProperty("主体名称")
    private String companyName;


    @ApiModelProperty("类型编号")
    private Integer typeId;

    @TableField(exist = false)
    @Deprecated
    @ApiModelProperty("类型编号")
    private String typeNo;
//    @TableField(exist = false)
    @ApiModelProperty("类型标题")
    private String typeName;


    @TableField(exist = false)
    private Integer accountingSubjectId;

    @Deprecated
    @TableField(exist = false)
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
//    @TableField(exist = false)
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;


    @ApiModelProperty("创建人id")
    private Integer createUserid;
    @ApiModelProperty("创建人编号")
    private String createUsercode;
    @ApiModelProperty("创建人名称")
    private String createUsername;

    @ApiModelProperty("付款理由")
    private String costReason;
    @ApiModelProperty("费用单备注")
    private String costRemark;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("关联父单")
    private String supCostNo;

    @ApiModelProperty("费用计划状态 0 待确认  1 已确认")
    private Integer costPlanStatus;
    @ApiModelProperty("文件地址")
    private String filePath;
    @ApiModelProperty("补充材料地址")
    private String morFilePath;
    @ApiModelProperty("费用总金额")
    private BigDecimal planAmount;

    @ApiModelProperty("二级物流供应商ID")
    private Integer subLogisticsSupplierId;
    @ApiModelProperty("一级物流供应商ID")
    private Integer logisticsSupplierId;

    @ApiModelProperty("收款银行（平台")
    private String bankName;
    @ApiModelProperty("收款账户")
    private String bankCard;
    @ApiModelProperty("收款用户名")
    private String bankCardUser;
    @ApiModelProperty("收款/付款单位")
    private String bankCompany;

    @ApiModelProperty("补充信息")
    private String morRemark;

    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm;
    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend;

    @ApiModelProperty("借支单已还金额")
    private BigDecimal hadPay;
    @ApiModelProperty("借支单状态 1 未还 2 部分还款  3 结清")
    private Integer lendStatus;

    @ApiModelProperty("驳回原因")
    private String rejectReason;

    /*借还单参数 start*/
    @ApiModelProperty("借支单补偿金额")
    private BigDecimal compensate;
    @ApiModelProperty("借还单冲销金额 (对应借支单币种)")
    private BigDecimal counteract;
    @ApiModelProperty("借还单归还金额 (对应借支单币种)")
    private BigDecimal lendBalance;
    @ApiModelProperty("对应借支单币种")
    private String dic;


    @ApiModelProperty("借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract;
    @ApiModelProperty("借还单归还金额 （ 支付币种 ）")
    private BigDecimal payLendBalance;
    @ApiModelProperty("计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount;
    @ApiModelProperty("支付币种")
    private String payDic;
    @ApiModelProperty("借还单 借还支付币种 -> 借支币种汇率")
    private BigDecimal payCur;
    /*借还单参数 end*/


    @TableField(value = "`attach`", typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;
    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;


    ///-------
    @TableField(exist = false)
    private CostTemplate costTemplate;

    @TableField(exist = false)
    @ApiModelProperty("借还单 借还支付币种 -> 借支币种汇率")
    private BigDecimal cur;

    private String lendType;


    public CostPlanDto castToDto() {
        StatusMapper statusMapper = SpringContextUtil.getBean(StatusMapper.class);

        CostPlanDto costPlanDto = new CostPlanDto();
        BeanUtils.copyProperties(this, costPlanDto);
        costPlanDto.setCostFormDto(statusMapper.getStatusValue("cost_form", costPlanDto.getCostForm()));
        costPlanDto.setIsLendDto(statusMapper.getStatusValue("is_lend", costPlanDto.getIsLend()));
        costPlanDto.setCostPlanStatusDto(statusMapper.getStatusValue("cost_plan_status", costPlanDto.getCostPlanStatus()));
        if (1 == costPlanDto.getCostForm()) {
            costPlanDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", costPlanDto.getIsTax()));
        } else {
            costPlanDto.setIsTaxStr("");
        }
        return costPlanDto;
    }
}
