package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.ICostCurrentReviewerService;
import com.blt.other.module.cost.service.ICostTemplateService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import com.google.common.collect.Lists;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/8 6:02 下午
 */
@Transactional
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("prod")
class FinancialCheckStateTest {

    @Resource
    CostService costService;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    ICostCurrentReviewerService costCurrentReviewerService;
    @Resource
    FinancialCheckState financialCheckState;
    @Autowired
    ICostTemplateService costTemplateService;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;

    @Test
    @Rollback(value = false)
    public void reSet() {
        List<String> costs = Lists.newArrayList("F031366", "F031367", "F031370");
        costs.forEach(this::reSet);
    }

    private void reSet(String costNo) {
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(costDomain.getCompanyNo());


        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getReferId, costCompanyDomain.getId())
                .eq(CostReviewer::getType, CostReviewer.financialReviewer));

        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
    }

    @Rollback(value = false)
    @Test
    void updateCurrentReviewer() {

        CostDomain costDomain = costService.getCostByCostNo("F031533");
        CostContext costContext = new CostContext("F031533", costDomain.getCreateUserid());
        costContext.setCostState(financialCheckState);
        financialCheckState.updateCurrentReviewer();
    }

    @Rollback
    @Test
    void Test() {
        CostDomain costDomain = costService.getCostByCostNo("F056167");
        List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
        CostCurrentReviewer costCurrentReviewer = null;
        Optional<CostCurrentReviewer> listCostCurrentReviewer = costCurrentReviewerList.stream().filter(l -> l.getOaUserId() == 720).findFirst();
        if(listCostCurrentReviewer.isPresent()) {
            listCostCurrentReviewer.get();
        } else  {
            listCostCurrentReviewer = costCurrentReviewerList.stream().filter(l -> l.getOaUserId() == 4936).findFirst();
            if(listCostCurrentReviewer.isPresent()) {
                costCurrentReviewer = listCostCurrentReviewer.get();
            } else {

            }
        }






//        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());
//        String aa = "(审核人民币金额【" + costDomain.getAmountRmb() + "】少于单据模板设定金额【" + costTemplate.getFinalMinimumReviewAmount() + "】)";
//        System.out.println(aa);
//        if (!costTemplate.shouldFinalCheck(costDomain)) {
//            return;
//        }
    }
}
